/* mga_ucode.h -- Matrox G200/G400 WARP engine microcode -*- linux-c -*-
 * Created: Thu Jan 11 21:20:43 2001 by gareth@valinux.com
 *
 * Copyright 1999 Matrox Graphics Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * MATROX GRAPHICS INC., OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Kernel-based WARP engine management:
 *    Gareth Hughes <gareth@valinux.com>
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/sys/dev/drm/mga_ucode.h 152909 2005-11-28 23:13:57Z anholt $");

/*
 * WARP pipes are named according to the functions they perform, where:
 *
 *   - T stands for computation of texture stage 0
 *   - T2 stands for computation of both texture stage 0 and texture stage 1
 *   - G stands for computation of triangle intensity (Gouraud interpolation)
 *   - Z stands for computation of Z buffer interpolation
 *   - S stands for computation of specular highlight
 *   - A stands for computation of the alpha channel
 *   - F stands for computation of vertex fog interpolation
 */

static unsigned char warp_g200_tgz[] = {

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x72, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x60, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x03, 0x80, 0x0A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x3C, 0x27, 0x4F, 0xE9,

	0x57, 0x39, 0x20, 0xE9,
	0x28, 0x19, 0x60, 0xEC,

	0x2B, 0x32, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0xB3, 0x05,
	0x00, 0xE0,
	0x16, 0x28, 0x20, 0xE9,

	0x23, 0x3B, 0x33, 0xAD,
	0x1E, 0x2B, 0x20, 0xE9,

	0x1C, 0x80, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x85, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x84, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x82, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x7F, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g200_tgza[] = {

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x7D, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x6B, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x2D, 0x44, 0x4C, 0xB6,
	0x25, 0x44, 0x54, 0xB6,

	0x03, 0x80, 0x2A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x2D, 0x20,
	0x25, 0x20,
	0x07, 0xC0, 0x44, 0xC6,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x3C, 0x27, 0x4F, 0xE9,

	0x1F, 0x62, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x3F, 0x3D, 0x5D, 0x9F,
	0x00, 0xE0,
	0x07, 0x20,

	0x00, 0x80, 0x00, 0xE8,
	0x28, 0x19, 0x60, 0xEC,

	0xB3, 0x05,
	0x00, 0xE0,
	0x00, 0x80, 0x00, 0xE8,

	0x23, 0x3B, 0x33, 0xAD,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0x26, 0x1F, 0xDF,
	0x9D, 0x1F, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x9E, 0x3F, 0x4F, 0xE9,

	0x07, 0x07, 0x1F, 0xAF,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x9C, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x57, 0x39, 0x20, 0xE9,

	0x16, 0x28, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0x1E, 0x2B, 0x20, 0xE9,
	0x2B, 0x32, 0x20, 0xE9,

	0x1C, 0x23, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x7A, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x79, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x77, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x74, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g200_tgzaf[] = {

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x83, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x21, 0x45, 0x80, 0xE8,
	0x1A, 0x4D, 0x80, 0xE8,

	0x31, 0x55, 0x80, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x6F, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0D, 0x21, 0x1A, 0xB6,
	0x05, 0x21, 0x31, 0xB6,

	0x2D, 0x44, 0x4C, 0xB6,
	0x25, 0x44, 0x54, 0xB6,

	0x03, 0x80, 0x2A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x0D, 0x20,
	0x05, 0x20,
	0x2F, 0xC0, 0x21, 0xC6,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x3C, 0x27, 0x4F, 0xE9,

	0x00, 0xE0,
	0x25, 0x20,
	0x07, 0xC0, 0x44, 0xC6,

	0x17, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x2D, 0x20,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0xE0,
	0x2F, 0x20,

	0x1F, 0x62, 0x57, 0x9F,
	0x00, 0xE0,
	0x07, 0x20,

	0x3F, 0x3D, 0x5D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x28, 0x19, 0x60, 0xEC,

	0xB3, 0x05,
	0x00, 0xE0,
	0x17, 0x26, 0x17, 0xDF,

	0x23, 0x3B, 0x33, 0xAD,
	0x35, 0x17, 0x4F, 0xE9,

	0x1F, 0x26, 0x1F, 0xDF,
	0x9D, 0x1F, 0x4F, 0xE9,

	0x9E, 0x3F, 0x4F, 0xE9,
	0x39, 0x37, 0x4F, 0xE9,

	0x2F, 0x2F, 0x17, 0xAF,
	0x00, 0x80, 0x00, 0xE8,

	0x07, 0x07, 0x1F, 0xAF,
	0x00, 0x80, 0x00, 0xE8,

	0x31, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x9C, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x57, 0x39, 0x20, 0xE9,

	0x16, 0x28, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0x1E, 0x2B, 0x20, 0xE9,
	0x2B, 0x32, 0x20, 0xE9,

	0x1C, 0x23, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x74, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x73, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x71, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x6E, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g200_tgzf[] = {

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x7F, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x21, 0x45, 0x80, 0xE8,
	0x1A, 0x4D, 0x80, 0xE8,

	0x31, 0x55, 0x80, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x6B, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0D, 0x21, 0x1A, 0xB6,
	0x05, 0x21, 0x31, 0xB6,

	0x03, 0x80, 0x2A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x0D, 0x20,
	0x05, 0x20,
	0x2F, 0xC0, 0x21, 0xC6,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x3C, 0x27, 0x4F, 0xE9,

	0x17, 0x50, 0x56, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0xE0,
	0x2F, 0x20,

	0x00, 0x80, 0x00, 0xE8,
	0x28, 0x19, 0x60, 0xEC,

	0xB3, 0x05,
	0x00, 0xE0,
	0x00, 0x80, 0x00, 0xE8,

	0x23, 0x3B, 0x33, 0xAD,
	0x00, 0x80, 0x00, 0xE8,

	0x17, 0x26, 0x17, 0xDF,
	0x35, 0x17, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x39, 0x37, 0x4F, 0xE9,

	0x2F, 0x2F, 0x17, 0xAF,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x31, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x57, 0x39, 0x20, 0xE9,

	0x16, 0x28, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0x1E, 0x2B, 0x20, 0xE9,
	0x2B, 0x32, 0x20, 0xE9,

	0x1C, 0x23, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x78, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x77, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x75, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x72, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g200_tgzs[] = {

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x8B, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x21, 0x45, 0x80, 0xE8,
	0x1A, 0x4D, 0x80, 0xE8,

	0x31, 0x55, 0x80, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x77, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x2D, 0x21, 0x1A, 0xB0,
	0x25, 0x21, 0x31, 0xB0,

	0x0D, 0x21, 0x1A, 0xB2,
	0x05, 0x21, 0x31, 0xB2,

	0x03, 0x80, 0x2A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x2D, 0x20,
	0x25, 0x20,
	0x05, 0x20,
	0x0D, 0x20,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x2F, 0xC0, 0x21, 0xC0,

	0x16, 0x42, 0x56, 0x9F,
	0x3C, 0x27, 0x4F, 0xE9,

	0x1E, 0x62, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x21, 0x31, 0xB4,
	0x2D, 0x21, 0x1A, 0xB4,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0x05,
	0x00, 0xE0,
	0x28, 0x19, 0x60, 0xEC,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0xE0,
	0x2F, 0x20,

	0x23, 0x3B, 0x33, 0xAD,
	0x1E, 0x26, 0x1E, 0xDF,

	0xA7, 0x1E, 0x4F, 0xE9,
	0x17, 0x26, 0x16, 0xDF,

	0x2D, 0x20,
	0x00, 0xE0,
	0xA8, 0x3F, 0x4F, 0xE9,

	0x2F, 0x2F, 0x1E, 0xAF,
	0x25, 0x20,
	0x00, 0xE0,

	0xA4, 0x16, 0x4F, 0xE9,
	0x0F, 0xC0, 0x21, 0xC2,

	0xA6, 0x80, 0x4F, 0xE9,
	0x1F, 0x62, 0x57, 0x9F,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0xE0,
	0x8F, 0x20,

	0xA5, 0x37, 0x4F, 0xE9,
	0x0F, 0x17, 0x0F, 0xAF,

	0x06, 0xC0, 0x21, 0xC4,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0xA3, 0x80, 0x4F, 0xE9,

	0x06, 0x20,
	0x00, 0xE0,
	0x1F, 0x26, 0x1F, 0xDF,

	0xA1, 0x1F, 0x4F, 0xE9,
	0xA2, 0x3F, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x06, 0x06, 0x1F, 0xAF,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x57, 0x39, 0x20, 0xE9,

	0x16, 0x28, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0x1E, 0x2B, 0x20, 0xE9,
	0x2B, 0x32, 0x20, 0xE9,

	0x1C, 0x23, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x6C, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x6B, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x69, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g200_tgzsa[] = {

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x8F, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x21, 0x45, 0x80, 0xE8,
	0x1A, 0x4D, 0x80, 0xE8,

	0x31, 0x55, 0x80, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x7B, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x2D, 0x21, 0x1A, 0xB0,
	0x25, 0x21, 0x31, 0xB0,

	0x0D, 0x21, 0x1A, 0xB2,
	0x05, 0x21, 0x31, 0xB2,

	0x03, 0x80, 0x2A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x2D, 0x20,
	0x25, 0x20,
	0x05, 0x20,
	0x0D, 0x20,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x2F, 0xC0, 0x21, 0xC0,

	0x16, 0x42, 0x56, 0x9F,
	0x3C, 0x27, 0x4F, 0xE9,

	0x1E, 0x62, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x21, 0x31, 0xB4,
	0x2D, 0x21, 0x1A, 0xB4,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0x05,
	0x00, 0xE0,
	0x28, 0x19, 0x60, 0xEC,

	0x0D, 0x44, 0x4C, 0xB6,
	0x05, 0x44, 0x54, 0xB6,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0xE0,
	0x2F, 0x20,

	0x23, 0x3B, 0x33, 0xAD,
	0x1E, 0x26, 0x1E, 0xDF,

	0xA7, 0x1E, 0x4F, 0xE9,
	0x17, 0x26, 0x16, 0xDF,

	0x2D, 0x20,
	0x00, 0xE0,
	0xA8, 0x3F, 0x4F, 0xE9,

	0x2F, 0x2F, 0x1E, 0xAF,
	0x25, 0x20,
	0x00, 0xE0,

	0xA4, 0x16, 0x4F, 0xE9,
	0x0F, 0xC0, 0x21, 0xC2,

	0xA6, 0x80, 0x4F, 0xE9,
	0x1F, 0x62, 0x57, 0x9F,

	0x0D, 0x20,
	0x05, 0x20,
	0x00, 0x80, 0x00, 0xE8,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0xE0,
	0x0F, 0x20,

	0x17, 0x50, 0x56, 0x9F,
	0xA5, 0x37, 0x4F, 0xE9,

	0x06, 0xC0, 0x21, 0xC4,
	0x0F, 0x17, 0x0F, 0xAF,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x2F, 0xC0, 0x44, 0xC6,
	0xA3, 0x80, 0x4F, 0xE9,

	0x06, 0x20,
	0x00, 0xE0,
	0x1F, 0x26, 0x1F, 0xDF,

	0x17, 0x26, 0x17, 0xDF,
	0x9D, 0x17, 0x4F, 0xE9,

	0xA1, 0x1F, 0x4F, 0xE9,
	0xA2, 0x3F, 0x4F, 0xE9,

	0x06, 0x06, 0x1F, 0xAF,
	0x00, 0xE0,
	0xAF, 0x20,

	0x9E, 0x37, 0x4F, 0xE9,
	0x2F, 0x17, 0x2F, 0xAF,

	0xA0, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x9C, 0x80, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x57, 0x39, 0x20, 0xE9,

	0x16, 0x28, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0x1E, 0x2B, 0x20, 0xE9,
	0x2B, 0x32, 0x20, 0xE9,

	0x1C, 0x23, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x68, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x67, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x65, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x62, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g200_tgzsaf[] = {

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x94, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x21, 0x45, 0x80, 0xE8,
	0x1A, 0x4D, 0x80, 0xE8,

	0x31, 0x55, 0x80, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x80, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x2D, 0x21, 0x1A, 0xB0,
	0x25, 0x21, 0x31, 0xB0,

	0x0D, 0x21, 0x1A, 0xB2,
	0x05, 0x21, 0x31, 0xB2,

	0x03, 0x80, 0x2A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x2D, 0x20,
	0x25, 0x20,
	0x05, 0x20,
	0x0D, 0x20,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x2F, 0xC0, 0x21, 0xC0,

	0x16, 0x42, 0x56, 0x9F,
	0x3C, 0x27, 0x4F, 0xE9,

	0x1E, 0x62, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x21, 0x31, 0xB4,
	0x2D, 0x21, 0x1A, 0xB4,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0x05,
	0x00, 0xE0,
	0x28, 0x19, 0x60, 0xEC,

	0x0D, 0x21, 0x1A, 0xB6,
	0x05, 0x21, 0x31, 0xB6,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0xE0,
	0x2F, 0x20,

	0x23, 0x3B, 0x33, 0xAD,
	0x1E, 0x26, 0x1E, 0xDF,

	0xA7, 0x1E, 0x4F, 0xE9,
	0x17, 0x26, 0x16, 0xDF,

	0x2D, 0x20,
	0x00, 0xE0,
	0xA8, 0x3F, 0x4F, 0xE9,

	0x2F, 0x2F, 0x1E, 0xAF,
	0x25, 0x20,
	0x00, 0xE0,

	0xA4, 0x16, 0x4F, 0xE9,
	0x0F, 0xC0, 0x21, 0xC2,

	0xA6, 0x80, 0x4F, 0xE9,
	0x1F, 0x62, 0x57, 0x9F,

	0x0D, 0x20,
	0x05, 0x20,
	0x2F, 0xC0, 0x21, 0xC6,

	0x2D, 0x44, 0x4C, 0xB6,
	0x25, 0x44, 0x54, 0xB6,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0xE0,
	0x0F, 0x20,

	0x2D, 0x20,
	0x25, 0x20,
	0x07, 0xC0, 0x44, 0xC6,

	0x17, 0x50, 0x56, 0x9F,
	0xA5, 0x37, 0x4F, 0xE9,

	0x06, 0xC0, 0x21, 0xC4,
	0x0F, 0x17, 0x0F, 0xAF,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x1E, 0x62, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x3E, 0x3D, 0x5D, 0x9F,
	0x00, 0xE0,
	0x07, 0x20,

	0x2F, 0x20,
	0x00, 0xE0,
	0xA3, 0x0F, 0x4F, 0xE9,

	0x06, 0x20,
	0x00, 0xE0,
	0x1F, 0x26, 0x1F, 0xDF,

	0x17, 0x26, 0x17, 0xDF,
	0xA1, 0x1F, 0x4F, 0xE9,

	0x1E, 0x26, 0x1E, 0xDF,
	0x9D, 0x1E, 0x4F, 0xE9,

	0x35, 0x17, 0x4F, 0xE9,
	0xA2, 0x3F, 0x4F, 0xE9,

	0x06, 0x06, 0x1F, 0xAF,
	0x39, 0x37, 0x4F, 0xE9,

	0x2F, 0x2F, 0x17, 0xAF,
	0x07, 0x07, 0x1E, 0xAF,

	0xA0, 0x80, 0x4F, 0xE9,
	0x9E, 0x3E, 0x4F, 0xE9,

	0x31, 0x80, 0x4F, 0xE9,
	0x9C, 0x80, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x57, 0x39, 0x20, 0xE9,

	0x16, 0x28, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0x1E, 0x2B, 0x20, 0xE9,
	0x2B, 0x32, 0x20, 0xE9,

	0x1C, 0x23, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x63, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x62, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x60, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x5D, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g200_tgzsf[] = {

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x98, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x81, 0x04,
	0x89, 0x04,
	0x01, 0x04,
	0x09, 0x04,

	0xC9, 0x41, 0xC0, 0xEC,
	0x11, 0x04,
	0x00, 0xE0,

	0x41, 0xCC, 0x41, 0xCD,
	0x49, 0xCC, 0x49, 0xCD,

	0xD1, 0x41, 0xC0, 0xEC,
	0x51, 0xCC, 0x51, 0xCD,

	0x80, 0x04,
	0x10, 0x04,
	0x08, 0x04,
	0x00, 0xE0,

	0x00, 0xCC, 0xC0, 0xCD,
	0xD1, 0x49, 0xC0, 0xEC,

	0x8A, 0x1F, 0x20, 0xE9,
	0x8B, 0x3F, 0x20, 0xE9,

	0x41, 0x3C, 0x41, 0xAD,
	0x49, 0x3C, 0x49, 0xAD,

	0x10, 0xCC, 0x10, 0xCD,
	0x08, 0xCC, 0x08, 0xCD,

	0xB9, 0x41, 0x49, 0xBB,
	0x1F, 0xF0, 0x41, 0xCD,

	0x51, 0x3C, 0x51, 0xAD,
	0x00, 0x98, 0x80, 0xE9,

	0x8F, 0x80, 0x07, 0xEA,
	0x24, 0x1F, 0x20, 0xE9,

	0x21, 0x45, 0x80, 0xE8,
	0x1A, 0x4D, 0x80, 0xE8,

	0x31, 0x55, 0x80, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0x41, 0x49, 0xBD,
	0x1D, 0x41, 0x51, 0xBD,

	0x2E, 0x41, 0x2A, 0xB8,
	0x34, 0x53, 0xA0, 0xE8,

	0x15, 0x30,
	0x1D, 0x30,
	0x58, 0xE3,
	0x00, 0xE0,

	0xB5, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x24, 0x43, 0xA0, 0xE8,
	0x2C, 0x4B, 0xA0, 0xE8,

	0x15, 0x72,
	0x09, 0xE3,
	0x00, 0xE0,
	0x1D, 0x72,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0x97, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x6C, 0x64, 0xC8, 0xEC,
	0x98, 0xE1,
	0xB5, 0x05,

	0xBD, 0x05,
	0x2E, 0x30,
	0x32, 0xC0, 0xA0, 0xE8,

	0x33, 0xC0, 0xA0, 0xE8,
	0x74, 0x64, 0xC8, 0xEC,

	0x40, 0x3C, 0x40, 0xAD,
	0x32, 0x6A,
	0x2A, 0x30,

	0x20, 0x73,
	0x33, 0x6A,
	0x00, 0xE0,
	0x28, 0x73,

	0x1C, 0x72,
	0x83, 0xE2,
	0x7B, 0x80, 0x15, 0xEA,

	0xB8, 0x3D, 0x28, 0xDF,
	0x30, 0x35, 0x20, 0xDF,

	0x40, 0x30,
	0x00, 0xE0,
	0xCC, 0xE2,
	0x64, 0x72,

	0x25, 0x42, 0x52, 0xBF,
	0x2D, 0x42, 0x4A, 0xBF,

	0x30, 0x2E, 0x30, 0xDF,
	0x38, 0x2E, 0x38, 0xDF,

	0x18, 0x1D, 0x45, 0xE9,
	0x1E, 0x15, 0x45, 0xE9,

	0x2B, 0x49, 0x51, 0xBD,
	0x00, 0xE0,
	0x1F, 0x73,

	0x38, 0x38, 0x40, 0xAF,
	0x30, 0x30, 0x40, 0xAF,

	0x24, 0x1F, 0x24, 0xDF,
	0x1D, 0x32, 0x20, 0xE9,

	0x2C, 0x1F, 0x2C, 0xDF,
	0x1A, 0x33, 0x20, 0xE9,

	0xB0, 0x10,
	0x08, 0xE3,
	0x40, 0x10,
	0xB8, 0x10,

	0x26, 0xF0, 0x30, 0xCD,
	0x2F, 0xF0, 0x38, 0xCD,

	0x2B, 0x80, 0x20, 0xE9,
	0x2A, 0x80, 0x20, 0xE9,

	0xA6, 0x20,
	0x88, 0xE2,
	0x00, 0xE0,
	0xAF, 0x20,

	0x28, 0x2A, 0x26, 0xAF,
	0x20, 0x2A, 0xC0, 0xAF,

	0x34, 0x1F, 0x34, 0xDF,
	0x46, 0x24, 0x46, 0xDF,

	0x28, 0x30, 0x80, 0xBF,
	0x20, 0x38, 0x80, 0xBF,

	0x47, 0x24, 0x47, 0xDF,
	0x4E, 0x2C, 0x4E, 0xDF,

	0x4F, 0x2C, 0x4F, 0xDF,
	0x56, 0x34, 0x56, 0xDF,

	0x28, 0x15, 0x28, 0xDF,
	0x20, 0x1D, 0x20, 0xDF,

	0x57, 0x34, 0x57, 0xDF,
	0x00, 0xE0,
	0x1D, 0x05,

	0x04, 0x80, 0x10, 0xEA,
	0x89, 0xE2,
	0x2B, 0x30,

	0x3F, 0xC1, 0x1D, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x68,
	0xBF, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x20, 0xC0, 0x20, 0xAF,
	0x28, 0x05,
	0x97, 0x74,

	0x00, 0xE0,
	0x2A, 0x10,
	0x16, 0xC0, 0x20, 0xE9,

	0x04, 0x80, 0x10, 0xEA,
	0x8C, 0xE2,
	0x95, 0x05,

	0x28, 0xC1, 0x28, 0xAD,
	0x1F, 0xC1, 0x15, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xA8, 0x67,
	0x9F, 0x6B,
	0x00, 0x80, 0x00, 0xE8,

	0x28, 0xC0, 0x28, 0xAD,
	0x1D, 0x25,
	0x20, 0x05,

	0x28, 0x32, 0x80, 0xAD,
	0x40, 0x2A, 0x40, 0xBD,

	0x1C, 0x80, 0x20, 0xE9,
	0x20, 0x33, 0x20, 0xAD,

	0x20, 0x73,
	0x00, 0xE0,
	0xB6, 0x49, 0x51, 0xBB,

	0x26, 0x2F, 0xB0, 0xE8,
	0x19, 0x20, 0x20, 0xE9,

	0x35, 0x20, 0x35, 0xDF,
	0x3D, 0x20, 0x3D, 0xDF,

	0x15, 0x20, 0x15, 0xDF,
	0x1D, 0x20, 0x1D, 0xDF,

	0x26, 0xD0, 0x26, 0xCD,
	0x29, 0x49, 0x2A, 0xB8,

	0x26, 0x40, 0x80, 0xBD,
	0x3B, 0x48, 0x50, 0xBD,

	0x3E, 0x54, 0x57, 0x9F,
	0x00, 0xE0,
	0x82, 0xE1,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x26, 0x30,
	0x29, 0x30,
	0x48, 0x3C, 0x48, 0xAD,

	0x2B, 0x72,
	0xC2, 0xE1,
	0x2C, 0xC0, 0x44, 0xC2,

	0x05, 0x24, 0x34, 0xBF,
	0x0D, 0x24, 0x2C, 0xBF,

	0x2D, 0x46, 0x4E, 0xBF,
	0x25, 0x46, 0x56, 0xBF,

	0x20, 0x1D, 0x6F, 0x8F,
	0x32, 0x3E, 0x5F, 0xE9,

	0x3E, 0x50, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x30,

	0x1E, 0x8F, 0x51, 0x9F,
	0x33, 0x1E, 0x5F, 0xE9,

	0x05, 0x44, 0x54, 0xB2,
	0x0D, 0x44, 0x4C, 0xB2,

	0x19, 0xC0, 0xB0, 0xE8,
	0x34, 0xC0, 0x44, 0xC4,

	0x33, 0x73,
	0x00, 0xE0,
	0x3E, 0x62, 0x57, 0x9F,

	0x1E, 0xAF, 0x59, 0x9F,
	0x00, 0xE0,
	0x0D, 0x20,

	0x84, 0x3E, 0x58, 0xE9,
	0x28, 0x1D, 0x6F, 0x8F,

	0x05, 0x20,
	0x00, 0xE0,
	0x85, 0x1E, 0x58, 0xE9,

	0x9B, 0x3B, 0x33, 0xDF,
	0x20, 0x20, 0x42, 0xAF,

	0x30, 0x42, 0x56, 0x9F,
	0x80, 0x3E, 0x57, 0xE9,

	0x3F, 0x8F, 0x51, 0x9F,
	0x30, 0x80, 0x5F, 0xE9,

	0x28, 0x28, 0x24, 0xAF,
	0x81, 0x1E, 0x57, 0xE9,

	0x05, 0x47, 0x57, 0xBF,
	0x0D, 0x47, 0x4F, 0xBF,

	0x88, 0x80, 0x58, 0xE9,
	0x1B, 0x29, 0x1B, 0xDF,

	0x30, 0x1D, 0x6F, 0x8F,
	0x3A, 0x30, 0x4F, 0xE9,

	0x1C, 0x30, 0x26, 0xDF,
	0x09, 0xE3,
	0x3B, 0x05,

	0x3E, 0x50, 0x56, 0x9F,
	0x3B, 0x3F, 0x4F, 0xE9,

	0x1E, 0x8F, 0x51, 0x9F,
	0x00, 0xE0,
	0xAC, 0x20,

	0x2D, 0x44, 0x4C, 0xB4,
	0x2C, 0x1C, 0xC0, 0xAF,

	0x25, 0x44, 0x54, 0xB4,
	0x00, 0xE0,
	0xC8, 0x30,

	0x30, 0x46, 0x30, 0xAF,
	0x1B, 0x1B, 0x48, 0xAF,

	0x00, 0xE0,
	0x25, 0x20,
	0x38, 0x2C, 0x4F, 0xE9,

	0x86, 0x80, 0x57, 0xE9,
	0x38, 0x1D, 0x6F, 0x8F,

	0x28, 0x74,
	0x00, 0xE0,
	0x0D, 0x44, 0x4C, 0xB0,

	0x05, 0x44, 0x54, 0xB0,
	0x2D, 0x20,
	0x9B, 0x10,

	0x82, 0x3E, 0x57, 0xE9,
	0x32, 0xF0, 0x1B, 0xCD,

	0x1E, 0xBD, 0x59, 0x9F,
	0x83, 0x1E, 0x57, 0xE9,

	0x38, 0x47, 0x38, 0xAF,
	0x34, 0x20,
	0x2A, 0x30,

	0x00, 0xE0,
	0x0D, 0x20,
	0x32, 0x20,
	0x05, 0x20,

	0x87, 0x80, 0x57, 0xE9,
	0x1F, 0x54, 0x57, 0x9F,

	0x17, 0x42, 0x56, 0x9F,
	0x00, 0xE0,
	0x3B, 0x6A,

	0x3F, 0x8F, 0x51, 0x9F,
	0x37, 0x1E, 0x4F, 0xE9,

	0x37, 0x32, 0x2A, 0xAF,
	0x00, 0xE0,
	0x32, 0x00,

	0x00, 0x80, 0x00, 0xE8,
	0x27, 0xC0, 0x44, 0xC0,

	0x36, 0x1F, 0x4F, 0xE9,
	0x1F, 0x1F, 0x26, 0xDF,

	0x37, 0x1B, 0x37, 0xBF,
	0x17, 0x26, 0x17, 0xDF,

	0x3E, 0x17, 0x4F, 0xE9,
	0x3F, 0x3F, 0x4F, 0xE9,

	0x34, 0x1F, 0x34, 0xAF,
	0x2B, 0x05,
	0xA7, 0x20,

	0x33, 0x2B, 0x37, 0xDF,
	0x27, 0x17, 0xC0, 0xAF,

	0x34, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x2D, 0x21, 0x1A, 0xB0,
	0x25, 0x21, 0x31, 0xB0,

	0x0D, 0x21, 0x1A, 0xB2,
	0x05, 0x21, 0x31, 0xB2,

	0x03, 0x80, 0x2A, 0xEA,
	0x17, 0xC1, 0x2B, 0xBD,

	0x2D, 0x20,
	0x25, 0x20,
	0x05, 0x20,
	0x0D, 0x20,

	0xB3, 0x68,
	0x97, 0x25,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0xC0, 0x33, 0xAF,
	0x2F, 0xC0, 0x21, 0xC0,

	0x16, 0x42, 0x56, 0x9F,
	0x3C, 0x27, 0x4F, 0xE9,

	0x1E, 0x62, 0x57, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x21, 0x31, 0xB4,
	0x2D, 0x21, 0x1A, 0xB4,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x33, 0x05,
	0x00, 0xE0,
	0x28, 0x19, 0x60, 0xEC,

	0x0D, 0x21, 0x1A, 0xB6,
	0x05, 0x21, 0x31, 0xB6,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0xE0,
	0x2F, 0x20,

	0x23, 0x3B, 0x33, 0xAD,
	0x1E, 0x26, 0x1E, 0xDF,

	0xA7, 0x1E, 0x4F, 0xE9,
	0x17, 0x26, 0x16, 0xDF,

	0x2D, 0x20,
	0x00, 0xE0,
	0xA8, 0x3F, 0x4F, 0xE9,

	0x2F, 0x2F, 0x1E, 0xAF,
	0x25, 0x20,
	0x00, 0xE0,

	0xA4, 0x16, 0x4F, 0xE9,
	0x0F, 0xC0, 0x21, 0xC2,

	0xA6, 0x80, 0x4F, 0xE9,
	0x1F, 0x62, 0x57, 0x9F,

	0x0D, 0x20,
	0x05, 0x20,
	0x2F, 0xC0, 0x21, 0xC6,

	0x3F, 0x2F, 0x5D, 0x9F,
	0x00, 0xE0,
	0x0F, 0x20,

	0x17, 0x50, 0x56, 0x9F,
	0xA5, 0x37, 0x4F, 0xE9,

	0x06, 0xC0, 0x21, 0xC4,
	0x0F, 0x17, 0x0F, 0xAF,

	0x37, 0x0F, 0x5C, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x2F, 0x20,
	0x00, 0xE0,
	0xA3, 0x80, 0x4F, 0xE9,

	0x06, 0x20,
	0x00, 0xE0,
	0x1F, 0x26, 0x1F, 0xDF,

	0x17, 0x26, 0x17, 0xDF,
	0x35, 0x17, 0x4F, 0xE9,

	0xA1, 0x1F, 0x4F, 0xE9,
	0xA2, 0x3F, 0x4F, 0xE9,

	0x06, 0x06, 0x1F, 0xAF,
	0x39, 0x37, 0x4F, 0xE9,

	0x2F, 0x2F, 0x17, 0xAF,
	0x00, 0x80, 0x00, 0xE8,

	0xA0, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x31, 0x80, 0x4F, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x57, 0x39, 0x20, 0xE9,

	0x16, 0x28, 0x20, 0xE9,
	0x1D, 0x3B, 0x20, 0xE9,

	0x1E, 0x2B, 0x20, 0xE9,
	0x2B, 0x32, 0x20, 0xE9,

	0x1C, 0x23, 0x20, 0xE9,
	0x57, 0x36, 0x20, 0xE9,

	0x00, 0x80, 0xA0, 0xE9,
	0x40, 0x40, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x90, 0xE2,
	0x00, 0xE0,

	0x68, 0xFF, 0x20, 0xEA,
	0x19, 0xC8, 0xC1, 0xCD,

	0x1F, 0xD7, 0x18, 0xBD,
	0x3F, 0xD7, 0x22, 0xBD,

	0x9F, 0x41, 0x49, 0xBD,
	0x00, 0x80, 0x00, 0xE8,

	0x25, 0x41, 0x49, 0xBD,
	0x2D, 0x41, 0x51, 0xBD,

	0x0D, 0x80, 0x07, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x35, 0x40, 0x48, 0xBD,
	0x3D, 0x40, 0x50, 0xBD,

	0x00, 0x80, 0x00, 0xE8,
	0x25, 0x30,
	0x2D, 0x30,

	0x35, 0x30,
	0xB5, 0x30,
	0xBD, 0x30,
	0x3D, 0x30,

	0x9C, 0xA7, 0x5B, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x67, 0xFF, 0x0A, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0xC9, 0x41, 0xC8, 0xEC,
	0x42, 0xE1,
	0x00, 0xE0,

	0x65, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0xC8, 0x40, 0xC0, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x62, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

};

static unsigned char warp_g400_t2gz[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x78, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x69, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0x34, 0x80, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x25, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x3D, 0xCF, 0x74, 0xC2,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x2A, 0x44, 0x54, 0xB4,
	0x1A, 0x44, 0x64, 0xB4,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x9F, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xBE, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x7D, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_t2gza[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x7C, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x6D, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0x34, 0x80, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x29, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x0F, 0xCF, 0x74, 0xC6,
	0x3D, 0xCF, 0x74, 0xC2,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x0F, 0x20, 0xE9,

	0x0A, 0x44, 0x54, 0xB4,
	0x02, 0x44, 0x64, 0xB4,

	0x2A, 0x44, 0x54, 0xB6,
	0x1A, 0x44, 0x64, 0xB6,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x0A, 0x20,
	0x02, 0x20,
	0x2A, 0x20,
	0x1A, 0x20,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x36, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x37, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x9B, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xBA, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x79, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_t2gzaf[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x81, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x72, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x31, 0x53, 0x2F, 0x9F,
	0x34, 0x37, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x2E, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0x3D, 0xCF, 0x74, 0xC2,
	0x0F, 0xCF, 0x74, 0xC6,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x0F, 0x20, 0xE9,

	0x0A, 0x44, 0x54, 0xB4,
	0x02, 0x44, 0x64, 0xB4,

	0x2A, 0x44, 0x54, 0xB6,
	0x1A, 0x44, 0x64, 0xB6,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x0A, 0x20,
	0x02, 0x20,
	0x2A, 0x20,
	0x1A, 0x20,

	0x3D, 0xCF, 0x75, 0xC6,
	0x00, 0x80, 0x00, 0xE8,

	0x30, 0x50, 0x2E, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x0A, 0x45, 0x55, 0xB6,
	0x02, 0x45, 0x65, 0xB6,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x31, 0x3D, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x38, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x38, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x96, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xB5, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x74, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_t2gzf[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x7D, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x6E, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x39, 0xE5, 0x2C, 0x9F,
	0x34, 0x80, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x88, 0x73, 0x5E, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0F, 0xCF, 0x75, 0xC6,
	0x3C, 0x3D, 0x20, 0xE9,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x28, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x3D, 0xCF, 0x74, 0xC2,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x31, 0x0F, 0x20, 0xE9,

	0x0A, 0x44, 0x54, 0xB4,
	0x02, 0x44, 0x64, 0xB4,

	0x2A, 0x45, 0x55, 0xB6,
	0x1A, 0x45, 0x65, 0xB6,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x0A, 0x20,
	0x02, 0x20,
	0x2A, 0x20,
	0x1A, 0x20,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x36, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x37, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x39, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x9A, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xBB, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x78, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_t2gzs[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x85, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x76, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x0F, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x31, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x0F, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB4,
	0x1A, 0x44, 0x64, 0xB4,

	0x0A, 0x45, 0x55, 0xB0,
	0x02, 0x45, 0x65, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x2A, 0x45, 0x55, 0xB2,
	0x1A, 0x45, 0x65, 0xB2,

	0x0A, 0x45, 0x55, 0xB4,
	0x02, 0x45, 0x65, 0xB4,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x20,
	0x1A, 0x20,
	0x0A, 0x20,
	0x02, 0x20,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0xA7, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x92, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xB2, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x70, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_t2gzsa[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x8A, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x7B, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x0F, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x36, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x0F, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB4,
	0x1A, 0x44, 0x64, 0xB4,

	0x0A, 0x45, 0x55, 0xB0,
	0x02, 0x45, 0x65, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x45, 0x55, 0xB2,
	0x1A, 0x45, 0x65, 0xB2,

	0x0A, 0x45, 0x55, 0xB4,
	0x02, 0x45, 0x65, 0xB4,

	0x0F, 0xCF, 0x74, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA7, 0x30, 0x4F, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x2A, 0x44, 0x54, 0xB6,
	0x1A, 0x44, 0x64, 0xB6,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x8D, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xAD, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x6B, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_t2gzsaf[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x8E, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x7F, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x0F, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x3A, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x0F, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB4,
	0x1A, 0x44, 0x64, 0xB4,

	0x0A, 0x45, 0x55, 0xB0,
	0x02, 0x45, 0x65, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x45, 0x55, 0xB2,
	0x1A, 0x45, 0x65, 0xB2,

	0x0A, 0x45, 0x55, 0xB4,
	0x02, 0x45, 0x65, 0xB4,

	0x0F, 0xCF, 0x74, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA7, 0x30, 0x4F, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x2A, 0x44, 0x54, 0xB6,
	0x1A, 0x44, 0x64, 0xB6,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x0A, 0x45, 0x55, 0xB6,
	0x02, 0x45, 0x65, 0xB6,

	0x3D, 0xCF, 0x75, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x31, 0x3D, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x38, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x89, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xA9, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x67, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_t2gzsf[] = {

	0x00, 0x8A, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x0A, 0x40, 0x50, 0xBF,
	0x2A, 0x40, 0x60, 0xBF,

	0x32, 0x41, 0x51, 0xBF,
	0x3A, 0x41, 0x61, 0xBF,

	0xC3, 0x6B,
	0xD3, 0x6B,
	0x00, 0x8A, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x53, 0xA0, 0xE8,

	0xAD, 0xEE, 0x23, 0x9F,
	0x00, 0xE0,
	0x51, 0x04,

	0x90, 0xE2,
	0x61, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x51, 0x41, 0xE0, 0xEC,
	0x39, 0x67, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x63, 0xA0, 0xE8,

	0x61, 0x41, 0xE0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x8A, 0x80, 0x15, 0xEA,
	0x10, 0x04,
	0x20, 0x04,

	0x61, 0x51, 0xE0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x52, 0xBF,
	0x0F, 0x52, 0xA0, 0xE8,

	0x1A, 0x42, 0x62, 0xBF,
	0x1E, 0x51, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x0E, 0x61, 0x60, 0xEA,

	0x32, 0x40, 0x50, 0xBD,
	0x22, 0x40, 0x60, 0xBD,

	0x12, 0x41, 0x51, 0xBD,
	0x3A, 0x41, 0x61, 0xBD,

	0xBF, 0x2F, 0x0E, 0xBD,
	0x97, 0xE2,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x35, 0x48, 0xB1, 0xE8,
	0x3D, 0x59, 0xB1, 0xE8,

	0x46, 0x31, 0x46, 0xBF,
	0x56, 0x31, 0x56, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x66, 0x31, 0x66, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x57, 0x39, 0x57, 0xBF,
	0x67, 0x39, 0x67, 0xBF,

	0x7B, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x35, 0x00,
	0x3D, 0x00,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0x8D, 0x2F, 0x1E, 0xBD,

	0x43, 0x75, 0xF8, 0xEC,
	0x35, 0x20,
	0x3D, 0x20,

	0x43, 0x43, 0x2D, 0xDF,
	0x53, 0x53, 0x2D, 0xDF,

	0xAE, 0x1E, 0x0E, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x48, 0x35, 0x48, 0xBF,
	0x58, 0x35, 0x58, 0xBF,

	0x68, 0x35, 0x68, 0xBF,
	0x49, 0x3D, 0x49, 0xBF,

	0x59, 0x3D, 0x59, 0xBF,
	0x69, 0x3D, 0x69, 0xBF,

	0x63, 0x63, 0x2D, 0xDF,
	0x4D, 0x7D, 0xF8, 0xEC,

	0x59, 0xE3,
	0x00, 0xE0,
	0xB8, 0x38, 0x33, 0xBF,

	0x2D, 0x73,
	0x30, 0x76,
	0x18, 0x3A, 0x41, 0xE9,

	0x3F, 0x53, 0xA0, 0xE8,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x63, 0xA0, 0xE8,

	0x50, 0x70, 0xF8, 0xEC,
	0x2B, 0x50, 0x3C, 0xE9,

	0x1F, 0x0F, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x59, 0x78, 0xF8, 0xEC,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x46, 0x37, 0x46, 0xDF,
	0x56, 0x3F, 0x56, 0xDF,

	0x2B, 0x40, 0x3D, 0xE9,
	0x66, 0x3D, 0x66, 0xDF,

	0x1D, 0x32, 0x41, 0xE9,
	0x67, 0x3D, 0x67, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3F, 0x57, 0xDF,

	0x2A, 0x40, 0x20, 0xE9,
	0x59, 0x3F, 0x59, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x69, 0x3D, 0x69, 0xDF,

	0x48, 0x37, 0x48, 0xDF,
	0x58, 0x3F, 0x58, 0xDF,

	0x68, 0x3D, 0x68, 0xDF,
	0x49, 0x37, 0x49, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x0F, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x54, 0xB0,
	0x02, 0x44, 0x64, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB2,
	0x1A, 0x44, 0x64, 0xB2,

	0x36, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x0F, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x54, 0xB4,
	0x1A, 0x44, 0x64, 0xB4,

	0x0A, 0x45, 0x55, 0xB0,
	0x02, 0x45, 0x65, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x45, 0x55, 0xB2,
	0x1A, 0x45, 0x65, 0xB2,

	0x0A, 0x45, 0x55, 0xB4,
	0x02, 0x45, 0x65, 0xB4,

	0x0F, 0xCF, 0x75, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA7, 0x30, 0x4F, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x31, 0x0F, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x2A, 0x45, 0x55, 0xB6,
	0x1A, 0x45, 0x65, 0xB6,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x56, 0xBF,
	0x1A, 0x46, 0x66, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x0A, 0x47, 0x57, 0xBF,
	0x02, 0x47, 0x67, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x53, 0xBF,
	0x1A, 0x43, 0x63, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x39, 0x4F, 0xE9,

	0x0A, 0x48, 0x58, 0xBF,
	0x02, 0x48, 0x68, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x2A, 0x49, 0x59, 0xBF,
	0x1A, 0x49, 0x69, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x82, 0x30, 0x57, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x83, 0x38, 0x57, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x84, 0x31, 0x5E, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x85, 0x39, 0x5E, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8A, 0x36, 0x20, 0xE9,

	0x87, 0x77, 0x57, 0xE9,
	0x8B, 0x3E, 0xBF, 0xEA,

	0x80, 0x30, 0x57, 0xE9,
	0x81, 0x38, 0x57, 0xE9,

	0x82, 0x31, 0x57, 0xE9,
	0x86, 0x78, 0x57, 0xE9,

	0x83, 0x39, 0x57, 0xE9,
	0x87, 0x79, 0x57, 0xE9,

	0x30, 0x1F, 0x5F, 0xE9,
	0x8A, 0x34, 0x20, 0xE9,

	0x8B, 0x3C, 0x20, 0xE9,
	0x37, 0x50, 0x60, 0xBD,

	0x57, 0x0D, 0x20, 0xE9,
	0x35, 0x51, 0x61, 0xBD,

	0x2B, 0x50, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x0E, 0x77,

	0x24, 0x51, 0x20, 0xE9,
	0x8D, 0xFF, 0x20, 0xEA,

	0x16, 0x0E, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x0B, 0x46, 0xA0, 0xE8,
	0x1B, 0x56, 0xA0, 0xE8,

	0x2B, 0x66, 0xA0, 0xE8,
	0x0C, 0x47, 0xA0, 0xE8,

	0x1C, 0x57, 0xA0, 0xE8,
	0x2C, 0x67, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x57, 0x80, 0x57, 0xCF,

	0x66, 0x33, 0x66, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x67, 0x3B, 0x67, 0xCF,

	0x0B, 0x48, 0xA0, 0xE8,
	0x1B, 0x58, 0xA0, 0xE8,

	0x2B, 0x68, 0xA0, 0xE8,
	0x0C, 0x49, 0xA0, 0xE8,

	0x1C, 0x59, 0xA0, 0xE8,
	0x2C, 0x69, 0xA0, 0xE8,

	0x0B, 0x00,
	0x1B, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x0C, 0x00,
	0x1C, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x0B, 0x65,
	0x1B, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x0C, 0x65,
	0x1C, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x0B, 0x1B, 0x60, 0xEC,
	0x34, 0xD7, 0x34, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x0C, 0x1C, 0x60, 0xEC,

	0x3C, 0xD7, 0x3C, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x0B, 0x2B, 0xDE, 0xE8,
	0x1B, 0x80, 0xDE, 0xE8,

	0x34, 0x80, 0x34, 0xBD,
	0x3C, 0x80, 0x3C, 0xBD,

	0x33, 0xD7, 0x0B, 0xBD,
	0x3B, 0xD7, 0x1B, 0xBD,

	0x48, 0x80, 0x48, 0xCF,
	0x59, 0x80, 0x59, 0xCF,

	0x68, 0x33, 0x68, 0xCF,
	0x49, 0x3B, 0x49, 0xCF,

	0xAD, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x58, 0x33, 0x58, 0xCF,
	0x69, 0x3B, 0x69, 0xCF,

	0x6B, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgz[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x58, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x4A, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0x34, 0x80, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x1D, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x3D, 0xCF, 0x74, 0xC2,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x2A, 0x44, 0x4C, 0xB4,
	0x1A, 0x44, 0x54, 0xB4,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0xAF, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xD6, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x9D, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgza[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x5C, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x4E, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0x34, 0x80, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x27, 0xCF, 0x74, 0xC6,
	0x3D, 0xCF, 0x74, 0xC2,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x20, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x27, 0x20, 0xE9,

	0x0A, 0x44, 0x4C, 0xB4,
	0x02, 0x44, 0x54, 0xB4,

	0x2A, 0x44, 0x4C, 0xB6,
	0x1A, 0x44, 0x54, 0xB6,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x0A, 0x20,
	0x02, 0x20,
	0x2A, 0x20,
	0x1A, 0x20,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x36, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x37, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0xAB, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xD3, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x99, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgzaf[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x61, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x53, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x31, 0x53, 0x2F, 0x9F,
	0x34, 0x37, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x26, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0x3D, 0xCF, 0x74, 0xC2,
	0x27, 0xCF, 0x74, 0xC6,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x27, 0x20, 0xE9,

	0x0A, 0x44, 0x4C, 0xB4,
	0x02, 0x44, 0x54, 0xB4,

	0x2A, 0x44, 0x4C, 0xB6,
	0x1A, 0x44, 0x54, 0xB6,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x0A, 0x20,
	0x02, 0x20,
	0x2A, 0x20,
	0x1A, 0x20,

	0x3D, 0xCF, 0x75, 0xC6,
	0x00, 0x80, 0x00, 0xE8,

	0x30, 0x50, 0x2E, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x0A, 0x45, 0x4D, 0xB6,
	0x02, 0x45, 0x55, 0xB6,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x31, 0x3D, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x38, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x38, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0xA6, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xCD, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x94, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgzf[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x5D, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x4F, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x3D, 0xCF, 0x74, 0xC0,
	0x37, 0xCF, 0x74, 0xC4,

	0x39, 0xE5, 0x2C, 0x9F,
	0x34, 0x80, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x88, 0x73, 0x5E, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x27, 0xCF, 0x75, 0xC6,
	0x3C, 0x3D, 0x20, 0xE9,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x20, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x3D, 0xCF, 0x74, 0xC2,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x31, 0x27, 0x20, 0xE9,

	0x0A, 0x44, 0x4C, 0xB4,
	0x02, 0x44, 0x54, 0xB4,

	0x2A, 0x45, 0x4D, 0xB6,
	0x1A, 0x45, 0x55, 0xB6,

	0x39, 0xE5, 0x2C, 0x9F,
	0x38, 0x3D, 0x20, 0xE9,

	0x0A, 0x20,
	0x02, 0x20,
	0x2A, 0x20,
	0x1A, 0x20,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x36, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x37, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0xAA, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xD3, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x98, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgzs[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x65, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x57, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x27, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x29, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x27, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB4,
	0x1A, 0x44, 0x54, 0xB4,

	0x0A, 0x45, 0x4D, 0xB0,
	0x02, 0x45, 0x55, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x2A, 0x45, 0x4D, 0xB2,
	0x1A, 0x45, 0x55, 0xB2,

	0x0A, 0x45, 0x4D, 0xB4,
	0x02, 0x45, 0x55, 0xB4,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x0A, 0x20,
	0x02, 0x20,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0xA7, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0xA2, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xCA, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x90, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgzsa[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x6A, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x5C, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x27, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x2E, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x27, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB4,
	0x1A, 0x44, 0x54, 0xB4,

	0x0A, 0x45, 0x4D, 0xB0,
	0x02, 0x45, 0x55, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x45, 0x4D, 0xB2,
	0x1A, 0x45, 0x55, 0xB2,

	0x0A, 0x45, 0x4D, 0xB4,
	0x02, 0x45, 0x55, 0xB4,

	0x27, 0xCF, 0x74, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA7, 0x30, 0x4F, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x2A, 0x44, 0x4C, 0xB6,
	0x1A, 0x44, 0x54, 0xB6,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0x9D, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xC5, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x8B, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgzsaf[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x6E, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x60, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x27, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x32, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x27, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB4,
	0x1A, 0x44, 0x54, 0xB4,

	0x0A, 0x45, 0x4D, 0xB0,
	0x02, 0x45, 0x55, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x45, 0x4D, 0xB2,
	0x1A, 0x45, 0x55, 0xB2,

	0x0A, 0x45, 0x4D, 0xB4,
	0x02, 0x45, 0x55, 0xB4,

	0x27, 0xCF, 0x74, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA7, 0x30, 0x4F, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x9C, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x2A, 0x44, 0x4C, 0xB6,
	0x1A, 0x44, 0x54, 0xB6,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x0A, 0x45, 0x4D, 0xB6,
	0x02, 0x45, 0x55, 0xB6,

	0x3D, 0xCF, 0x75, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x31, 0x3D, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x9D, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x9E, 0x39, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x30, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x38, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0x99, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xC1, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x87, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};

static unsigned char warp_g400_tgzsf[] = {

	0x00, 0x88, 0x98, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

	0xFF, 0x80, 0xC0, 0xE9,
	0x00, 0x80, 0x00, 0xE8,

	0x22, 0x40, 0x48, 0xBF,
	0x2A, 0x40, 0x50, 0xBF,

	0x32, 0x41, 0x49, 0xBF,
	0x3A, 0x41, 0x51, 0xBF,

	0xC3, 0x6B,
	0xCB, 0x6B,
	0x00, 0x88, 0x98, 0xE9,

	0x73, 0x7B, 0xC8, 0xEC,
	0x96, 0xE2,
	0x41, 0x04,

	0x7B, 0x43, 0xA0, 0xE8,
	0x73, 0x4B, 0xA0, 0xE8,

	0xAD, 0xEE, 0x29, 0x9F,
	0x00, 0xE0,
	0x49, 0x04,

	0x90, 0xE2,
	0x51, 0x04,
	0x31, 0x46, 0xB1, 0xE8,

	0x49, 0x41, 0xC0, 0xEC,
	0x39, 0x57, 0xB1, 0xE8,

	0x00, 0x04,
	0x46, 0xE2,
	0x73, 0x53, 0xA0, 0xE8,

	0x51, 0x41, 0xC0, 0xEC,
	0x31, 0x00,
	0x39, 0x00,

	0x6A, 0x80, 0x15, 0xEA,
	0x08, 0x04,
	0x10, 0x04,

	0x51, 0x49, 0xC0, 0xEC,
	0x2F, 0x41, 0x60, 0xEA,

	0x31, 0x20,
	0x39, 0x20,
	0x1F, 0x42, 0xA0, 0xE8,

	0x2A, 0x42, 0x4A, 0xBF,
	0x27, 0x4A, 0xA0, 0xE8,

	0x1A, 0x42, 0x52, 0xBF,
	0x1E, 0x49, 0x60, 0xEA,

	0x73, 0x7B, 0xC8, 0xEC,
	0x26, 0x51, 0x60, 0xEA,

	0x32, 0x40, 0x48, 0xBD,
	0x22, 0x40, 0x50, 0xBD,

	0x12, 0x41, 0x49, 0xBD,
	0x3A, 0x41, 0x51, 0xBD,

	0xBF, 0x2F, 0x26, 0xBD,
	0x00, 0xE0,
	0x7B, 0x72,

	0x32, 0x20,
	0x22, 0x20,
	0x12, 0x20,
	0x3A, 0x20,

	0x46, 0x31, 0x46, 0xBF,
	0x4E, 0x31, 0x4E, 0xBF,

	0xB3, 0xE2, 0x2D, 0x9F,
	0x00, 0x80, 0x00, 0xE8,

	0x56, 0x31, 0x56, 0xBF,
	0x47, 0x39, 0x47, 0xBF,

	0x4F, 0x39, 0x4F, 0xBF,
	0x57, 0x39, 0x57, 0xBF,

	0x5C, 0x80, 0x07, 0xEA,
	0x24, 0x41, 0x20, 0xE9,

	0x42, 0x73, 0xF8, 0xEC,
	0x00, 0xE0,
	0x2D, 0x73,

	0x33, 0x72,
	0x0C, 0xE3,
	0xA5, 0x2F, 0x1E, 0xBD,

	0x43, 0x43, 0x2D, 0xDF,
	0x4B, 0x4B, 0x2D, 0xDF,

	0xAE, 0x1E, 0x26, 0xBD,
	0x58, 0xE3,
	0x33, 0x66,

	0x53, 0x53, 0x2D, 0xDF,
	0x00, 0x80, 0x00, 0xE8,

	0xB8, 0x38, 0x33, 0xBF,
	0x00, 0xE0,
	0x59, 0xE3,

	0x1E, 0x12, 0x41, 0xE9,
	0x1A, 0x22, 0x41, 0xE9,

	0x2B, 0x40, 0x3D, 0xE9,
	0x3F, 0x4B, 0xA0, 0xE8,

	0x2D, 0x73,
	0x30, 0x76,
	0x05, 0x80, 0x3D, 0xEA,

	0x37, 0x43, 0xA0, 0xE8,
	0x3D, 0x53, 0xA0, 0xE8,

	0x48, 0x70, 0xF8, 0xEC,
	0x2B, 0x48, 0x3C, 0xE9,

	0x1F, 0x27, 0xBC, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x00, 0x80, 0x00, 0xE8,
	0x00, 0x80, 0x00, 0xE8,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x15, 0xC0, 0x20, 0xE9,
	0x15, 0xC0, 0x20, 0xE9,

	0x18, 0x3A, 0x41, 0xE9,
	0x1D, 0x32, 0x41, 0xE9,

	0x2A, 0x40, 0x20, 0xE9,
	0x56, 0x3D, 0x56, 0xDF,

	0x46, 0x37, 0x46, 0xDF,
	0x4E, 0x3F, 0x4E, 0xDF,

	0x16, 0x30, 0x20, 0xE9,
	0x4F, 0x3F, 0x4F, 0xDF,

	0x47, 0x37, 0x47, 0xDF,
	0x57, 0x3D, 0x57, 0xDF,

	0x32, 0x32, 0x2D, 0xDF,
	0x22, 0x22, 0x2D, 0xDF,

	0x12, 0x12, 0x2D, 0xDF,
	0x3A, 0x3A, 0x2D, 0xDF,

	0x27, 0xCF, 0x74, 0xC2,
	0x37, 0xCF, 0x74, 0xC4,

	0x0A, 0x44, 0x4C, 0xB0,
	0x02, 0x44, 0x54, 0xB0,

	0x3D, 0xCF, 0x74, 0xC0,
	0x34, 0x37, 0x20, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x38, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3C, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB2,
	0x1A, 0x44, 0x54, 0xB2,

	0x2E, 0x80, 0x3A, 0xEA,
	0x0A, 0x20,
	0x02, 0x20,

	0x27, 0xCF, 0x75, 0xC0,
	0x2A, 0x20,
	0x1A, 0x20,

	0x30, 0x50, 0x2E, 0x9F,
	0x32, 0x31, 0x5F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x33, 0x39, 0x5F, 0xE9,

	0x3D, 0xCF, 0x75, 0xC2,
	0x37, 0xCF, 0x75, 0xC4,

	0x31, 0x53, 0x2F, 0x9F,
	0xA6, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA3, 0x3D, 0x20, 0xE9,

	0x2A, 0x44, 0x4C, 0xB4,
	0x1A, 0x44, 0x54, 0xB4,

	0x0A, 0x45, 0x4D, 0xB0,
	0x02, 0x45, 0x55, 0xB0,

	0x88, 0x73, 0x5E, 0xE9,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA0, 0x37, 0x20, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x3E, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x3F, 0x38, 0x4F, 0xE9,

	0x30, 0x50, 0x2E, 0x9F,
	0x3A, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x3B, 0x39, 0x4F, 0xE9,

	0x2A, 0x45, 0x4D, 0xB2,
	0x1A, 0x45, 0x55, 0xB2,

	0x0A, 0x45, 0x4D, 0xB4,
	0x02, 0x45, 0x55, 0xB4,

	0x27, 0xCF, 0x75, 0xC6,
	0x2A, 0x20,
	0x1A, 0x20,

	0xA7, 0x30, 0x4F, 0xE9,
	0x0A, 0x20,
	0x02, 0x20,

	0x31, 0x53, 0x2F, 0x9F,
	0x31, 0x27, 0x20, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA8, 0x38, 0x4F, 0xE9,

	0x2A, 0x45, 0x4D, 0xB6,
	0x1A, 0x45, 0x55, 0xB6,

	0x30, 0x50, 0x2E, 0x9F,
	0x36, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x37, 0x39, 0x4F, 0xE9,

	0x00, 0x80, 0x00, 0xE8,
	0x2A, 0x20,
	0x1A, 0x20,

	0x2A, 0x46, 0x4E, 0xBF,
	0x1A, 0x46, 0x56, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA4, 0x31, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA5, 0x39, 0x4F, 0xE9,

	0x0A, 0x47, 0x4F, 0xBF,
	0x02, 0x47, 0x57, 0xBF,

	0x31, 0x53, 0x2F, 0x9F,
	0xA1, 0x30, 0x4F, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0xA2, 0x38, 0x4F, 0xE9,

	0x2A, 0x43, 0x4B, 0xBF,
	0x1A, 0x43, 0x53, 0xBF,

	0x30, 0x50, 0x2E, 0x9F,
	0x35, 0x31, 0x4F, 0xE9,

	0x38, 0x21, 0x2C, 0x9F,
	0x39, 0x39, 0x4F, 0xE9,

	0x31, 0x53, 0x2F, 0x9F,
	0x80, 0x31, 0x57, 0xE9,

	0x39, 0xE5, 0x2C, 0x9F,
	0x81, 0x39, 0x57, 0xE9,

	0x37, 0x48, 0x50, 0xBD,
	0x8A, 0x36, 0x20, 0xE9,

	0x86, 0x76, 0x57, 0xE9,
	0x8B, 0x3E, 0x20, 0xE9,

	0x82, 0x30, 0x57, 0xE9,
	0x87, 0x77, 0x57, 0xE9,

	0x83, 0x38, 0x57, 0xE9,
	0x35, 0x49, 0x51, 0xBD,

	0x84, 0x31, 0x5E, 0xE9,
	0x30, 0x1F, 0x5F, 0xE9,

	0x85, 0x39, 0x5E, 0xE9,
	0x57, 0x25, 0x20, 0xE9,

	0x2B, 0x48, 0x20, 0xE9,
	0x1D, 0x37, 0xE1, 0xEA,

	0x1E, 0x35, 0xE1, 0xEA,
	0x00, 0xE0,
	0x26, 0x77,

	0x24, 0x49, 0x20, 0xE9,
	0x9D, 0xFF, 0x20, 0xEA,

	0x16, 0x26, 0x20, 0xE9,
	0x57, 0x2E, 0xBF, 0xEA,

	0x1C, 0x46, 0xA0, 0xE8,
	0x23, 0x4E, 0xA0, 0xE8,

	0x2B, 0x56, 0xA0, 0xE8,
	0x1D, 0x47, 0xA0, 0xE8,

	0x24, 0x4F, 0xA0, 0xE8,
	0x2C, 0x57, 0xA0, 0xE8,

	0x1C, 0x00,
	0x23, 0x00,
	0x2B, 0x00,
	0x00, 0xE0,

	0x1D, 0x00,
	0x24, 0x00,
	0x2C, 0x00,
	0x00, 0xE0,

	0x1C, 0x65,
	0x23, 0x65,
	0x2B, 0x65,
	0x00, 0xE0,

	0x1D, 0x65,
	0x24, 0x65,
	0x2C, 0x65,
	0x00, 0xE0,

	0x1C, 0x23, 0x60, 0xEC,
	0x36, 0xD7, 0x36, 0xAD,

	0x2B, 0x80, 0x60, 0xEC,
	0x1D, 0x24, 0x60, 0xEC,

	0x3E, 0xD7, 0x3E, 0xAD,
	0x2C, 0x80, 0x60, 0xEC,

	0x1C, 0x2B, 0xDE, 0xE8,
	0x23, 0x80, 0xDE, 0xE8,

	0x36, 0x80, 0x36, 0xBD,
	0x3E, 0x80, 0x3E, 0xBD,

	0x33, 0xD7, 0x1C, 0xBD,
	0x3B, 0xD7, 0x23, 0xBD,

	0x46, 0x80, 0x46, 0xCF,
	0x4F, 0x80, 0x4F, 0xCF,

	0x56, 0x33, 0x56, 0xCF,
	0x47, 0x3B, 0x47, 0xCF,

	0xC5, 0xFF, 0x20, 0xEA,
	0x00, 0x80, 0x00, 0xE8,

	0x4E, 0x33, 0x4E, 0xCF,
	0x57, 0x3B, 0x57, 0xCF,

	0x8B, 0xFF, 0x20, 0xEA,
	0x57, 0xC0, 0xBF, 0xEA,

	0x00, 0x80, 0xA0, 0xE9,
	0x00, 0x00, 0xD8, 0xEC,

};
