.NC "Network Service Interface"
.sh 1 "Connectionless Network Service"
.pp
This section describes the interface to the ISO connectionless network service.
There are really two interfaces to the CLNS: the internal interface
and the IPC interface.
The internal interface is based on
procedure calls. It is used only within the kernel. The IPC interface
allows a user process to access the CLNS directly. This is used only
for testing and debugging purposes.
.sh 2 "Primitives"
.pp
The CLNS is, by definition, connectionless. Therefore, there are no 
primitives associated with connection establishment or connection release.
There is one primitive associated with data transfer: N-UNITDATA.
The parameters to a N-UNITDATA request are: source NSAP address,
destination NSAP address, quality of service, and user data. 
The parameters of a N-UNITDATA indication are identical to those of the
request.
In this implementation, the quality of service parameter is not supported.
.sh 2 "Internal Interface"
.pp
Within the kernel, an N-UNITDATA request is effected by the procedure
\fIclnp_output()\fR:
.(b
\fC
.TS
tab(+);
l s s.
clnp_output(m0, isop, datalen, flags)
.T&
l l l.
 +struct mbuf+*m0;+/* data */
 +struct isopcb+*isop;+/* ISO protocol control block */
 +int+datalen;+
 +int+flags;+/* flags */
.TE
\fR
.)b
This procedure will construct a DT NPDU, route it, and transmit it on
the appropriate subnetwork. \fIM0\fR is an mbuf chain containing the 
user data portion of the N-UNITDATA request. \fIIsopcb\fR is the iso protocol
control block previously allocated. \fIClnp_output\fR will use the following
fields: \fIisop_laddr\fR, isop_faddr, isop_route, isop_options,
isop_optindex, \fI and \fRisop_clnpcache\fR.
\fIDatalen\fR specifies the number of bytes of user data.
The \fIflags\fR parameter will be discussed in a subsequent chapter.
.pp
A N-UNITDATA indication occurs when a DT NPDU arrives. The indication is
generated by calling the appropriate upper layer protocol input routine. 
In the case of TP, the procedure \fItpclnp_input()\fR is called:
.(b
\fC
.TS
tab(+);
l s s.
tpclnp_input(m, src, dst, len)
.T&
l l l.
 +struct mbuf+*m;+/* DT NPDU */
 +struct iso_addr+*src;+/* source of packet */
 +struct iso_addr+*dst;+/* destination of packet */
 +int+len;+/* length of clnp header */
.TE
\fR
.)b
\fIM\fR contains the entire DT NPDU packet. \fILen\fR indicates the size
of the CLNP header. In other words, the user data of the DT NPDU begins
\fIlen\fR bytes into \fIm\fR. \fISrc\fR and \fIdst\fR indicate the
source and destination NSAP addresses of the packet.
.sh 3 "CLNP/Subnetwork Interface"
.pp
The design of the interface between the subnetwork and the CLNP is 
determined by the design of the Unix network interface drivers. CLNP
follows the conventional mechanisms for exchanging packets with a network
interface. See the section on Network Interface Drivers in Chapter Five
for more information on these conventions.
.sh 2 "IPC (\*(lqRaw\*(rq) Interface"
.pp
The IPC interface to the CLNS allows direct (called \*(lqraw\*(rq) 
access to CLNP. 
This interface is intended for testing and debugging only. 
Its use results in the
transmission of CLNP datagrams with nonstandard identification fields.
These raw packets may be rejected by a system not employing the same
convention. See the section on network implementation for more information
about the conventions.
.pp
In order to gain access to the raw interface
a \fIsocket\fR, with address family AF_ISO and type SOCK_RAW must be created.
With this socket in hand,
the system calls \fIsendto()\fR and \fIrecvfrom()\fR can be used to 
transmit and receive raw CLNP datagrams. 
.sh 3 "Sending raw datagrams"
.pp
The format of the \fIsendto()\fR system call is:
.(b
\fC
.TS
tab(+);
l s s.
cc = sendto(s, msg, len, flags, to, tolen)
.T&
l l l.
int+cc,s;
char+*msg;
int+len,flags;
struct sockaddr+*to;
int+to;
.TE
\fR
.)b
\f\fIS\fR is the socket previously created. \fIMsg\fR is a pointer to
the data for the NPDU. CLNP will prepend a header to this data before
transmission. \fILen\fR specifies the number of bytes of data. The
\fIflags\fR parameter is unused and should be zero. \fITo\fR specifies the
NSAP address to be used as the destination address. The size (in bytes)
of \fIto\fR is given in \fItolen\fR. CLNP will automatically insert
the source address based upon the route taken by the packet. The number of
user data bytes transmitted is returned as \fIcc\fR. See \fIsendto(2)\fR
for more information on this system call.
.sh 3 "Receiving raw datagrams"
.pp
The format of the \fIrecvfrom()\fR system call is:
.(b
\fC
.TS
tab(+);
l s s.
cc = recvfrom(s, buf, len, flags, from, fromlen)
.T&
l l l.
int+cc,s;
char+*buf;
int+len,flags;
struct sockaddr+*from;
int+*fromlen;
.TE
\fR
.)b
When used with a CLNP raw socket \fIs\fR, \fIrecvfrom()\fR will read a 
NPDU from the CLNS. If no packet is available, the call will block.
\fIBuf\fR specifies a buffer of \fIlen\fR bytes into which the NPDU will
be read. The entire packet, including the header, will be read into the
buffer. The \fIflags\fR parameter is unused, and should be zero. If 
\fIfrom\fR is non-zero, the source address of the NPDU is filled in.
\fIFromlen\fR is a value-result parameter, initialized to the size of
the buffer associated with \fIfrom\fR, and modified on return to
indicate the actual size of the address stored there. The total number
of bytes received (header and data) is returned as \fIcc\fR.
See \fIrecvfrom(2)\fR for more information about this system call.
.sh 1 "Connection Oriented Network Service"
.pp
The ARGO Connection Oriented Network Service (CONS) is not a complete
implementation of the
OSI network service.
It is that subset of the OSI network service that is used
by ARGO Transport and by ARGO CLNP.
.\" FIGURE
.so figs/NS_primitives.nr
.pp
.CF
shows which CONS service elements are provided.
