/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * $FreeBSD: stable/7/sys/compat/freebsd32/freebsd32_sysent.c 196009 2009-08-01 01:54:42Z jhb $
 * created from FreeBSD: stable/7/sys/compat/freebsd32/syscalls.master 196006 2009-07-31 20:32:55Z jhb 
 */

#include "opt_compat.h"

#include <sys/param.h>
#include <sys/sysent.h>
#include <sys/sysproto.h>
#include <sys/mount.h>
#include <sys/socket.h>
#include <compat/freebsd32/freebsd32.h>
#include <compat/freebsd32/freebsd32_proto.h>

#define AS(name) (sizeof(struct name) / sizeof(register_t))

#ifdef COMPAT_43
#define compat(n, name) n, (sy_call_t *)__CONCAT(o,name)
#else
#define compat(n, name) 0, (sy_call_t *)nosys
#endif

#ifdef COMPAT_FREEBSD4
#define compat4(n, name) n, (sy_call_t *)__CONCAT(freebsd4_,name)
#else
#define compat4(n, name) 0, (sy_call_t *)nosys
#endif

#ifdef COMPAT_FREEBSD6
#define compat6(n, name) n, (sy_call_t *)__CONCAT(freebsd6_,name)
#else
#define compat6(n, name) 0, (sy_call_t *)nosys
#endif

/* The casts are bogus but will do for now. */
struct sysent freebsd32_sysent[] = {
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },		/* 0 = syscall */
	{ AS(sys_exit_args), (sy_call_t *)sys_exit, AUE_EXIT, NULL, 0, 0 },	/* 1 = exit */
	{ 0, (sy_call_t *)fork, AUE_FORK, NULL, 0, 0 },		/* 2 = fork */
	{ AS(read_args), (sy_call_t *)read, AUE_READ, NULL, 0, 0 },	/* 3 = read */
	{ AS(write_args), (sy_call_t *)write, AUE_WRITE, NULL, 0, 0 },	/* 4 = write */
	{ AS(open_args), (sy_call_t *)open, AUE_OPEN_RWTC, NULL, 0, 0 },	/* 5 = open */
	{ AS(close_args), (sy_call_t *)close, AUE_CLOSE, NULL, 0, 0 },	/* 6 = close */
	{ AS(freebsd32_wait4_args), (sy_call_t *)freebsd32_wait4, AUE_WAIT4, NULL, 0, 0 },	/* 7 = freebsd32_wait4 */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 8 = obsolete old creat */
	{ AS(link_args), (sy_call_t *)link, AUE_LINK, NULL, 0, 0 },	/* 9 = link */
	{ AS(unlink_args), (sy_call_t *)unlink, AUE_UNLINK, NULL, 0, 0 },	/* 10 = unlink */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 11 = obsolete execv */
	{ AS(chdir_args), (sy_call_t *)chdir, AUE_CHDIR, NULL, 0, 0 },	/* 12 = chdir */
	{ AS(fchdir_args), (sy_call_t *)fchdir, AUE_FCHDIR, NULL, 0, 0 },	/* 13 = fchdir */
	{ AS(mknod_args), (sy_call_t *)mknod, AUE_MKNOD, NULL, 0, 0 },	/* 14 = mknod */
	{ AS(chmod_args), (sy_call_t *)chmod, AUE_CHMOD, NULL, 0, 0 },	/* 15 = chmod */
	{ AS(chown_args), (sy_call_t *)chown, AUE_CHOWN, NULL, 0, 0 },	/* 16 = chown */
	{ AS(obreak_args), (sy_call_t *)obreak, AUE_NULL, NULL, 0, 0 },	/* 17 = break */
	{ compat4(AS(freebsd4_freebsd32_getfsstat_args),freebsd32_getfsstat), AUE_GETFSSTAT, NULL, 0, 0 },	/* 18 = freebsd4 freebsd32_getfsstat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 19 = obsolete olseek */
	{ 0, (sy_call_t *)getpid, AUE_GETPID, NULL, 0, 0 },		/* 20 = getpid */
	{ AS(mount_args), (sy_call_t *)mount, AUE_MOUNT, NULL, 0, 0 },	/* 21 = mount */
	{ AS(unmount_args), (sy_call_t *)unmount, AUE_UMOUNT, NULL, 0, 0 },	/* 22 = unmount */
	{ AS(setuid_args), (sy_call_t *)setuid, AUE_SETUID, NULL, 0, 0 },	/* 23 = setuid */
	{ 0, (sy_call_t *)getuid, AUE_GETUID, NULL, 0, 0 },		/* 24 = getuid */
	{ 0, (sy_call_t *)geteuid, AUE_GETEUID, NULL, 0, 0 },		/* 25 = geteuid */
	{ AS(ptrace_args), (sy_call_t *)ptrace, AUE_PTRACE, NULL, 0, 0 },	/* 26 = ptrace */
	{ AS(freebsd32_recvmsg_args), (sy_call_t *)freebsd32_recvmsg, AUE_RECVMSG, NULL, 0, 0 },	/* 27 = freebsd32_recvmsg */
	{ AS(freebsd32_sendmsg_args), (sy_call_t *)freebsd32_sendmsg, AUE_SENDMSG, NULL, 0, 0 },	/* 28 = freebsd32_sendmsg */
	{ AS(freebsd32_recvfrom_args), (sy_call_t *)freebsd32_recvfrom, AUE_RECVFROM, NULL, 0, 0 },	/* 29 = freebsd32_recvfrom */
	{ AS(accept_args), (sy_call_t *)accept, AUE_ACCEPT, NULL, 0, 0 },	/* 30 = accept */
	{ AS(getpeername_args), (sy_call_t *)getpeername, AUE_GETPEERNAME, NULL, 0, 0 },	/* 31 = getpeername */
	{ AS(getsockname_args), (sy_call_t *)getsockname, AUE_GETSOCKNAME, NULL, 0, 0 },	/* 32 = getsockname */
	{ AS(access_args), (sy_call_t *)access, AUE_ACCESS, NULL, 0, 0 },	/* 33 = access */
	{ AS(chflags_args), (sy_call_t *)chflags, AUE_CHFLAGS, NULL, 0, 0 },	/* 34 = chflags */
	{ AS(fchflags_args), (sy_call_t *)fchflags, AUE_FCHFLAGS, NULL, 0, 0 },	/* 35 = fchflags */
	{ 0, (sy_call_t *)sync, AUE_SYNC, NULL, 0, 0 },		/* 36 = sync */
	{ AS(kill_args), (sy_call_t *)kill, AUE_KILL, NULL, 0, 0 },	/* 37 = kill */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 38 = ostat */
	{ 0, (sy_call_t *)getppid, AUE_GETPPID, NULL, 0, 0 },		/* 39 = getppid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 40 = olstat */
	{ AS(dup_args), (sy_call_t *)dup, AUE_DUP, NULL, 0, 0 },	/* 41 = dup */
	{ 0, (sy_call_t *)pipe, AUE_PIPE, NULL, 0, 0 },		/* 42 = pipe */
	{ 0, (sy_call_t *)getegid, AUE_GETEGID, NULL, 0, 0 },		/* 43 = getegid */
	{ AS(profil_args), (sy_call_t *)profil, AUE_PROFILE, NULL, 0, 0 },	/* 44 = profil */
	{ AS(ktrace_args), (sy_call_t *)ktrace, AUE_KTRACE, NULL, 0, 0 },	/* 45 = ktrace */
	{ compat(AS(ofreebsd32_sigaction_args),freebsd32_sigaction), AUE_SIGACTION, NULL, 0, 0 },	/* 46 = old freebsd32_sigaction */
	{ 0, (sy_call_t *)getgid, AUE_GETGID, NULL, 0, 0 },		/* 47 = getgid */
	{ compat(AS(ofreebsd32_sigprocmask_args),freebsd32_sigprocmask), AUE_SIGPROCMASK, NULL, 0, 0 },	/* 48 = old freebsd32_sigprocmask */
	{ AS(getlogin_args), (sy_call_t *)getlogin, AUE_GETLOGIN, NULL, 0, 0 },	/* 49 = getlogin */
	{ AS(setlogin_args), (sy_call_t *)setlogin, AUE_SETLOGIN, NULL, 0, 0 },	/* 50 = setlogin */
	{ AS(acct_args), (sy_call_t *)acct, AUE_ACCT, NULL, 0, 0 },	/* 51 = acct */
	{ compat(0,freebsd32_sigpending), AUE_SIGPENDING, NULL, 0, 0 },	/* 52 = old freebsd32_sigpending */
	{ AS(freebsd32_sigaltstack_args), (sy_call_t *)freebsd32_sigaltstack, AUE_SIGALTSTACK, NULL, 0, 0 },	/* 53 = freebsd32_sigaltstack */
	{ AS(freebsd32_ioctl_args), (sy_call_t *)freebsd32_ioctl, AUE_NULL, NULL, 0, 0 },	/* 54 = freebsd32_ioctl */
	{ AS(reboot_args), (sy_call_t *)reboot, AUE_REBOOT, NULL, 0, 0 },	/* 55 = reboot */
	{ AS(revoke_args), (sy_call_t *)revoke, AUE_REVOKE, NULL, 0, 0 },	/* 56 = revoke */
	{ AS(symlink_args), (sy_call_t *)symlink, AUE_SYMLINK, NULL, 0, 0 },	/* 57 = symlink */
	{ AS(readlink_args), (sy_call_t *)readlink, AUE_READLINK, NULL, 0, 0 },	/* 58 = readlink */
	{ AS(freebsd32_execve_args), (sy_call_t *)freebsd32_execve, AUE_EXECVE, NULL, 0, 0 },	/* 59 = freebsd32_execve */
	{ AS(umask_args), (sy_call_t *)umask, AUE_UMASK, NULL, 0, 0 },	/* 60 = umask */
	{ AS(chroot_args), (sy_call_t *)chroot, AUE_CHROOT, NULL, 0, 0 },	/* 61 = chroot */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 62 = obsolete ofstat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 63 = obsolete ogetkerninfo */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 64 = obsolete ogetpagesize */
	{ AS(msync_args), (sy_call_t *)msync, AUE_MSYNC, NULL, 0, 0 },	/* 65 = msync */
	{ 0, (sy_call_t *)vfork, AUE_VFORK, NULL, 0, 0 },		/* 66 = vfork */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 67 = obsolete vread */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 68 = obsolete vwrite */
	{ AS(sbrk_args), (sy_call_t *)sbrk, AUE_SBRK, NULL, 0, 0 },	/* 69 = sbrk */
	{ AS(sstk_args), (sy_call_t *)sstk, AUE_SSTK, NULL, 0, 0 },	/* 70 = sstk */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 71 = obsolete ommap */
	{ AS(ovadvise_args), (sy_call_t *)ovadvise, AUE_O_VADVISE, NULL, 0, 0 },	/* 72 = vadvise */
	{ AS(munmap_args), (sy_call_t *)munmap, AUE_MUNMAP, NULL, 0, 0 },	/* 73 = munmap */
	{ AS(mprotect_args), (sy_call_t *)mprotect, AUE_MPROTECT, NULL, 0, 0 },	/* 74 = mprotect */
	{ AS(madvise_args), (sy_call_t *)madvise, AUE_MADVISE, NULL, 0, 0 },	/* 75 = madvise */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 76 = obsolete vhangup */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 77 = obsolete vlimit */
	{ AS(mincore_args), (sy_call_t *)mincore, AUE_MINCORE, NULL, 0, 0 },	/* 78 = mincore */
	{ AS(getgroups_args), (sy_call_t *)getgroups, AUE_GETGROUPS, NULL, 0, 0 },	/* 79 = getgroups */
	{ AS(setgroups_args), (sy_call_t *)setgroups, AUE_SETGROUPS, NULL, 0, 0 },	/* 80 = setgroups */
	{ 0, (sy_call_t *)getpgrp, AUE_GETPGRP, NULL, 0, 0 },		/* 81 = getpgrp */
	{ AS(setpgid_args), (sy_call_t *)setpgid, AUE_SETPGRP, NULL, 0, 0 },	/* 82 = setpgid */
	{ AS(freebsd32_setitimer_args), (sy_call_t *)freebsd32_setitimer, AUE_SETITIMER, NULL, 0, 0 },	/* 83 = freebsd32_setitimer */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 84 = obsolete owait */
	{ AS(swapon_args), (sy_call_t *)swapon, AUE_SWAPON, NULL, 0, 0 },	/* 85 = swapon */
	{ AS(freebsd32_getitimer_args), (sy_call_t *)freebsd32_getitimer, AUE_GETITIMER, NULL, 0, 0 },	/* 86 = freebsd32_getitimer */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 87 = obsolete ogethostname */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 88 = obsolete osethostname */
	{ 0, (sy_call_t *)getdtablesize, AUE_GETDTABLESIZE, NULL, 0, 0 },	/* 89 = getdtablesize */
	{ AS(dup2_args), (sy_call_t *)dup2, AUE_DUP2, NULL, 0, 0 },	/* 90 = dup2 */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 91 = getdopt */
	{ AS(fcntl_args), (sy_call_t *)fcntl, AUE_FCNTL, NULL, 0, 0 },	/* 92 = fcntl */
	{ AS(freebsd32_select_args), (sy_call_t *)freebsd32_select, AUE_SELECT, NULL, 0, 0 },	/* 93 = freebsd32_select */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 94 = setdopt */
	{ AS(fsync_args), (sy_call_t *)fsync, AUE_FSYNC, NULL, 0, 0 },	/* 95 = fsync */
	{ AS(setpriority_args), (sy_call_t *)setpriority, AUE_SETPRIORITY, NULL, 0, 0 },	/* 96 = setpriority */
	{ AS(socket_args), (sy_call_t *)socket, AUE_SOCKET, NULL, 0, 0 },	/* 97 = socket */
	{ AS(connect_args), (sy_call_t *)connect, AUE_CONNECT, NULL, 0, 0 },	/* 98 = connect */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 99 = obsolete oaccept */
	{ AS(getpriority_args), (sy_call_t *)getpriority, AUE_GETPRIORITY, NULL, 0, 0 },	/* 100 = getpriority */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 101 = obsolete osend */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 102 = obsolete orecv */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 103 = obsolete osigreturn */
	{ AS(bind_args), (sy_call_t *)bind, AUE_BIND, NULL, 0, 0 },	/* 104 = bind */
	{ AS(setsockopt_args), (sy_call_t *)setsockopt, AUE_SETSOCKOPT, NULL, 0, 0 },	/* 105 = setsockopt */
	{ AS(listen_args), (sy_call_t *)listen, AUE_LISTEN, NULL, 0, 0 },	/* 106 = listen */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 107 = obsolete vtimes */
	{ compat(AS(ofreebsd32_sigvec_args),freebsd32_sigvec), AUE_O_SIGVEC, NULL, 0, 0 },	/* 108 = old freebsd32_sigvec */
	{ compat(AS(ofreebsd32_sigblock_args),freebsd32_sigblock), AUE_O_SIGBLOCK, NULL, 0, 0 },	/* 109 = old freebsd32_sigblock */
	{ compat(AS(ofreebsd32_sigsetmask_args),freebsd32_sigsetmask), AUE_O_SIGSETMASK, NULL, 0, 0 },	/* 110 = old freebsd32_sigsetmask */
	{ compat(AS(ofreebsd32_sigsuspend_args),freebsd32_sigsuspend), AUE_SIGSUSPEND, NULL, 0, 0 },	/* 111 = old freebsd32_sigsuspend */
	{ compat(AS(ofreebsd32_sigstack_args),freebsd32_sigstack), AUE_O_SIGSTACK, NULL, 0, 0 },	/* 112 = old freebsd32_sigstack */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 113 = obsolete orecvmsg */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 114 = obsolete osendmsg */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 115 = obsolete vtrace */
	{ AS(freebsd32_gettimeofday_args), (sy_call_t *)freebsd32_gettimeofday, AUE_GETTIMEOFDAY, NULL, 0, 0 },	/* 116 = freebsd32_gettimeofday */
	{ AS(freebsd32_getrusage_args), (sy_call_t *)freebsd32_getrusage, AUE_GETRUSAGE, NULL, 0, 0 },	/* 117 = freebsd32_getrusage */
	{ AS(getsockopt_args), (sy_call_t *)getsockopt, AUE_GETSOCKOPT, NULL, 0, 0 },	/* 118 = getsockopt */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 119 = resuba */
	{ AS(freebsd32_readv_args), (sy_call_t *)freebsd32_readv, AUE_READV, NULL, 0, 0 },	/* 120 = freebsd32_readv */
	{ AS(freebsd32_writev_args), (sy_call_t *)freebsd32_writev, AUE_WRITEV, NULL, 0, 0 },	/* 121 = freebsd32_writev */
	{ AS(freebsd32_settimeofday_args), (sy_call_t *)freebsd32_settimeofday, AUE_SETTIMEOFDAY, NULL, 0, 0 },	/* 122 = freebsd32_settimeofday */
	{ AS(fchown_args), (sy_call_t *)fchown, AUE_FCHOWN, NULL, 0, 0 },	/* 123 = fchown */
	{ AS(fchmod_args), (sy_call_t *)fchmod, AUE_FCHMOD, NULL, 0, 0 },	/* 124 = fchmod */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 125 = obsolete orecvfrom */
	{ AS(setreuid_args), (sy_call_t *)setreuid, AUE_SETREUID, NULL, 0, 0 },	/* 126 = setreuid */
	{ AS(setregid_args), (sy_call_t *)setregid, AUE_SETREGID, NULL, 0, 0 },	/* 127 = setregid */
	{ AS(rename_args), (sy_call_t *)rename, AUE_RENAME, NULL, 0, 0 },	/* 128 = rename */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 129 = obsolete otruncate */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 130 = obsolete ftruncate */
	{ AS(flock_args), (sy_call_t *)flock, AUE_FLOCK, NULL, 0, 0 },	/* 131 = flock */
	{ AS(mkfifo_args), (sy_call_t *)mkfifo, AUE_MKFIFO, NULL, 0, 0 },	/* 132 = mkfifo */
	{ AS(sendto_args), (sy_call_t *)sendto, AUE_SENDTO, NULL, 0, 0 },	/* 133 = sendto */
	{ AS(shutdown_args), (sy_call_t *)shutdown, AUE_SHUTDOWN, NULL, 0, 0 },	/* 134 = shutdown */
	{ AS(socketpair_args), (sy_call_t *)socketpair, AUE_SOCKETPAIR, NULL, 0, 0 },	/* 135 = socketpair */
	{ AS(mkdir_args), (sy_call_t *)mkdir, AUE_MKDIR, NULL, 0, 0 },	/* 136 = mkdir */
	{ AS(rmdir_args), (sy_call_t *)rmdir, AUE_RMDIR, NULL, 0, 0 },	/* 137 = rmdir */
	{ AS(freebsd32_utimes_args), (sy_call_t *)freebsd32_utimes, AUE_UTIMES, NULL, 0, 0 },	/* 138 = freebsd32_utimes */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 139 = obsolete 4.2 sigreturn */
	{ AS(freebsd32_adjtime_args), (sy_call_t *)freebsd32_adjtime, AUE_ADJTIME, NULL, 0, 0 },	/* 140 = freebsd32_adjtime */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 141 = obsolete ogetpeername */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 142 = obsolete ogethostid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 143 = obsolete sethostid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 144 = obsolete getrlimit */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 145 = obsolete setrlimit */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 146 = obsolete killpg */
	{ 0, (sy_call_t *)setsid, AUE_SETSID, NULL, 0, 0 },		/* 147 = setsid */
	{ AS(quotactl_args), (sy_call_t *)quotactl, AUE_QUOTACTL, NULL, 0, 0 },	/* 148 = quotactl */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 149 = obsolete oquota */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 150 = obsolete ogetsockname */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 151 = sem_lock */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 152 = sem_wakeup */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 153 = asyncdaemon */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 154 = nlm_syscall */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 155 = nfssvc */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 156 = obsolete ogetdirentries */
	{ compat4(AS(freebsd4_freebsd32_statfs_args),freebsd32_statfs), AUE_STATFS, NULL, 0, 0 },	/* 157 = freebsd4 freebsd32_statfs */
	{ compat4(AS(freebsd4_freebsd32_fstatfs_args),freebsd32_fstatfs), AUE_FSTATFS, NULL, 0, 0 },	/* 158 = freebsd4 freebsd32_fstatfs */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 159 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 160 = lgetfh */
	{ AS(getfh_args), (sy_call_t *)getfh, AUE_NFS_GETFH, NULL, 0, 0 },	/* 161 = getfh */
	{ AS(getdomainname_args), (sy_call_t *)getdomainname, AUE_SYSCTL, NULL, 0, 0 },	/* 162 = getdomainname */
	{ AS(setdomainname_args), (sy_call_t *)setdomainname, AUE_SYSCTL, NULL, 0, 0 },	/* 163 = setdomainname */
	{ AS(uname_args), (sy_call_t *)uname, AUE_NULL, NULL, 0, 0 },	/* 164 = uname */
	{ AS(sysarch_args), (sy_call_t *)sysarch, AUE_SYSARCH, NULL, 0, 0 },	/* 165 = sysarch */
	{ AS(rtprio_args), (sy_call_t *)rtprio, AUE_RTPRIO, NULL, 0, 0 },	/* 166 = rtprio */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 167 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 168 = nosys */
	{ AS(freebsd32_semsys_args), (sy_call_t *)freebsd32_semsys, AUE_SEMSYS, NULL, 0, 0 },	/* 169 = freebsd32_semsys */
	{ AS(freebsd32_msgsys_args), (sy_call_t *)freebsd32_msgsys, AUE_MSGSYS, NULL, 0, 0 },	/* 170 = freebsd32_msgsys */
	{ AS(freebsd32_shmsys_args), (sy_call_t *)freebsd32_shmsys, AUE_SHMSYS, NULL, 0, 0 },	/* 171 = freebsd32_shmsys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 172 = nosys */
	{ compat6(AS(freebsd6_freebsd32_pread_args),freebsd32_pread), AUE_PREAD, NULL, 0, 0 },	/* 173 = freebsd6 freebsd32_pread */
	{ compat6(AS(freebsd6_freebsd32_pwrite_args),freebsd32_pwrite), AUE_PWRITE, NULL, 0, 0 },	/* 174 = freebsd6 freebsd32_pwrite */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 175 = nosys */
	{ AS(ntp_adjtime_args), (sy_call_t *)ntp_adjtime, AUE_NTP_ADJTIME, NULL, 0, 0 },	/* 176 = ntp_adjtime */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 177 = sfork */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 178 = getdescriptor */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 179 = setdescriptor */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 180 = nosys */
	{ AS(setgid_args), (sy_call_t *)setgid, AUE_SETGID, NULL, 0, 0 },	/* 181 = setgid */
	{ AS(setegid_args), (sy_call_t *)setegid, AUE_SETEGID, NULL, 0, 0 },	/* 182 = setegid */
	{ AS(seteuid_args), (sy_call_t *)seteuid, AUE_SETEUID, NULL, 0, 0 },	/* 183 = seteuid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 184 = lfs_bmapv */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 185 = lfs_markv */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 186 = lfs_segclean */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 187 = lfs_segwait */
	{ AS(freebsd32_stat_args), (sy_call_t *)freebsd32_stat, AUE_STAT, NULL, 0, 0 },	/* 188 = freebsd32_stat */
	{ AS(freebsd32_fstat_args), (sy_call_t *)freebsd32_fstat, AUE_FSTAT, NULL, 0, 0 },	/* 189 = freebsd32_fstat */
	{ AS(freebsd32_lstat_args), (sy_call_t *)freebsd32_lstat, AUE_LSTAT, NULL, 0, 0 },	/* 190 = freebsd32_lstat */
	{ AS(pathconf_args), (sy_call_t *)pathconf, AUE_PATHCONF, NULL, 0, 0 },	/* 191 = pathconf */
	{ AS(fpathconf_args), (sy_call_t *)fpathconf, AUE_FPATHCONF, NULL, 0, 0 },	/* 192 = fpathconf */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 193 = nosys */
	{ AS(__getrlimit_args), (sy_call_t *)getrlimit, AUE_GETRLIMIT, NULL, 0, 0 },	/* 194 = getrlimit */
	{ AS(__setrlimit_args), (sy_call_t *)setrlimit, AUE_SETRLIMIT, NULL, 0, 0 },	/* 195 = setrlimit */
	{ AS(freebsd32_getdirentries_args), (sy_call_t *)freebsd32_getdirentries, AUE_GETDIRENTRIES, NULL, 0, 0 },	/* 196 = freebsd32_getdirentries */
	{ compat6(AS(freebsd6_freebsd32_mmap_args),freebsd32_mmap), AUE_MMAP, NULL, 0, 0 },	/* 197 = freebsd6 freebsd32_mmap */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },		/* 198 = __syscall */
	{ compat6(AS(freebsd6_freebsd32_lseek_args),freebsd32_lseek), AUE_LSEEK, NULL, 0, 0 },	/* 199 = freebsd6 freebsd32_lseek */
	{ compat6(AS(freebsd6_freebsd32_truncate_args),freebsd32_truncate), AUE_TRUNCATE, NULL, 0, 0 },	/* 200 = freebsd6 freebsd32_truncate */
	{ compat6(AS(freebsd6_freebsd32_ftruncate_args),freebsd32_ftruncate), AUE_FTRUNCATE, NULL, 0, 0 },	/* 201 = freebsd6 freebsd32_ftruncate */
	{ AS(freebsd32_sysctl_args), (sy_call_t *)freebsd32_sysctl, AUE_SYSCTL, NULL, 0, 0 },	/* 202 = freebsd32_sysctl */
	{ AS(mlock_args), (sy_call_t *)mlock, AUE_MLOCK, NULL, 0, 0 },	/* 203 = mlock */
	{ AS(munlock_args), (sy_call_t *)munlock, AUE_MUNLOCK, NULL, 0, 0 },	/* 204 = munlock */
	{ AS(undelete_args), (sy_call_t *)undelete, AUE_UNDELETE, NULL, 0, 0 },	/* 205 = undelete */
	{ AS(freebsd32_futimes_args), (sy_call_t *)freebsd32_futimes, AUE_FUTIMES, NULL, 0, 0 },	/* 206 = freebsd32_futimes */
	{ AS(getpgid_args), (sy_call_t *)getpgid, AUE_GETPGID, NULL, 0, 0 },	/* 207 = getpgid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 208 = newreboot */
	{ AS(poll_args), (sy_call_t *)poll, AUE_POLL, NULL, 0, 0 },	/* 209 = poll */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 210 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 211 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 212 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 213 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 214 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 215 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 216 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 217 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 218 = lkmnosys */
	{ AS(nosys_args), (sy_call_t *)lkmnosys, AUE_NULL, NULL, 0, 0 },	/* 219 = lkmnosys */
	{ AS(freebsd7_freebsd32_semctl_args), (sy_call_t *)freebsd7_freebsd32_semctl, AUE_SEMCTL, NULL, 0, 0 },	/* 220 = freebsd7_freebsd32_semctl */
	{ AS(semget_args), (sy_call_t *)semget, AUE_SEMGET, NULL, 0, 0 },	/* 221 = semget */
	{ AS(semop_args), (sy_call_t *)semop, AUE_SEMOP, NULL, 0, 0 },	/* 222 = semop */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 223 = semconfig */
	{ AS(freebsd7_freebsd32_msgctl_args), (sy_call_t *)freebsd7_freebsd32_msgctl, AUE_MSGCTL, NULL, 0, 0 },	/* 224 = freebsd7_freebsd32_msgctl */
	{ AS(msgget_args), (sy_call_t *)msgget, AUE_MSGGET, NULL, 0, 0 },	/* 225 = msgget */
	{ AS(freebsd32_msgsnd_args), (sy_call_t *)freebsd32_msgsnd, AUE_MSGSND, NULL, 0, 0 },	/* 226 = freebsd32_msgsnd */
	{ AS(freebsd32_msgrcv_args), (sy_call_t *)freebsd32_msgrcv, AUE_MSGRCV, NULL, 0, 0 },	/* 227 = freebsd32_msgrcv */
	{ AS(shmat_args), (sy_call_t *)shmat, AUE_SHMAT, NULL, 0, 0 },	/* 228 = shmat */
	{ AS(freebsd7_freebsd32_shmctl_args), (sy_call_t *)freebsd7_freebsd32_shmctl, AUE_SHMCTL, NULL, 0, 0 },	/* 229 = freebsd7_freebsd32_shmctl */
	{ AS(shmdt_args), (sy_call_t *)shmdt, AUE_SHMDT, NULL, 0, 0 },	/* 230 = shmdt */
	{ AS(shmget_args), (sy_call_t *)shmget, AUE_SHMGET, NULL, 0, 0 },	/* 231 = shmget */
	{ AS(freebsd32_clock_gettime_args), (sy_call_t *)freebsd32_clock_gettime, AUE_NULL, NULL, 0, 0 },	/* 232 = freebsd32_clock_gettime */
	{ AS(freebsd32_clock_settime_args), (sy_call_t *)freebsd32_clock_settime, AUE_CLOCK_SETTIME, NULL, 0, 0 },	/* 233 = freebsd32_clock_settime */
	{ AS(freebsd32_clock_getres_args), (sy_call_t *)freebsd32_clock_getres, AUE_NULL, NULL, 0, 0 },	/* 234 = freebsd32_clock_getres */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 235 = timer_create */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 236 = timer_delete */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 237 = timer_settime */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 238 = timer_gettime */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 239 = timer_getoverrun */
	{ AS(freebsd32_nanosleep_args), (sy_call_t *)freebsd32_nanosleep, AUE_NULL, NULL, 0, 0 },	/* 240 = freebsd32_nanosleep */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 241 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 242 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 243 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 244 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 245 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 246 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 247 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 248 = ntp_gettime */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 249 = nosys */
	{ AS(minherit_args), (sy_call_t *)minherit, AUE_MINHERIT, NULL, 0, 0 },	/* 250 = minherit */
	{ AS(rfork_args), (sy_call_t *)rfork, AUE_RFORK, NULL, 0, 0 },	/* 251 = rfork */
	{ AS(openbsd_poll_args), (sy_call_t *)openbsd_poll, AUE_POLL, NULL, 0, 0 },	/* 252 = openbsd_poll */
	{ 0, (sy_call_t *)issetugid, AUE_ISSETUGID, NULL, 0, 0 },	/* 253 = issetugid */
	{ AS(lchown_args), (sy_call_t *)lchown, AUE_LCHOWN, NULL, 0, 0 },	/* 254 = lchown */
	{ AS(freebsd32_aio_read_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 255 = freebsd32_aio_read */
	{ AS(freebsd32_aio_write_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 256 = freebsd32_aio_write */
	{ AS(freebsd32_lio_listio_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 257 = freebsd32_lio_listio */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 258 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 259 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 260 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 261 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 262 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 263 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 264 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 265 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 266 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 267 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 268 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 269 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 270 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 271 = nosys */
	{ AS(getdents_args), (sy_call_t *)getdents, AUE_O_GETDENTS, NULL, 0, 0 },	/* 272 = getdents */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 273 = nosys */
	{ AS(lchmod_args), (sy_call_t *)lchmod, AUE_LCHMOD, NULL, 0, 0 },	/* 274 = lchmod */
	{ AS(lchown_args), (sy_call_t *)lchown, AUE_LCHOWN, NULL, 0, 0 },	/* 275 = netbsd_lchown */
	{ AS(freebsd32_lutimes_args), (sy_call_t *)freebsd32_lutimes, AUE_LUTIMES, NULL, 0, 0 },	/* 276 = freebsd32_lutimes */
	{ AS(msync_args), (sy_call_t *)msync, AUE_MSYNC, NULL, 0, 0 },	/* 277 = netbsd_msync */
	{ AS(nstat_args), (sy_call_t *)nstat, AUE_STAT, NULL, 0, 0 },	/* 278 = nstat */
	{ AS(nfstat_args), (sy_call_t *)nfstat, AUE_FSTAT, NULL, 0, 0 },	/* 279 = nfstat */
	{ AS(nlstat_args), (sy_call_t *)nlstat, AUE_LSTAT, NULL, 0, 0 },	/* 280 = nlstat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 281 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 282 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 283 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 284 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 285 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 286 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 287 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 288 = nosys */
	{ AS(freebsd32_preadv_args), (sy_call_t *)freebsd32_preadv, AUE_PREADV, NULL, 0, 0 },	/* 289 = freebsd32_preadv */
	{ AS(freebsd32_pwritev_args), (sy_call_t *)freebsd32_pwritev, AUE_PWRITEV, NULL, 0, 0 },	/* 290 = freebsd32_pwritev */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 291 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 292 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 293 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 294 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 295 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 296 = nosys */
	{ compat4(AS(freebsd4_freebsd32_fhstatfs_args),freebsd32_fhstatfs), AUE_FHSTATFS, NULL, 0, 0 },	/* 297 = freebsd4 freebsd32_fhstatfs */
	{ AS(fhopen_args), (sy_call_t *)fhopen, AUE_FHOPEN, NULL, 0, 0 },	/* 298 = fhopen */
	{ AS(fhstat_args), (sy_call_t *)fhstat, AUE_FHSTAT, NULL, 0, 0 },	/* 299 = fhstat */
	{ AS(modnext_args), (sy_call_t *)modnext, AUE_NULL, NULL, 0, 0 },	/* 300 = modnext */
	{ AS(freebsd32_modstat_args), (sy_call_t *)freebsd32_modstat, AUE_NULL, NULL, 0, 0 },	/* 301 = freebsd32_modstat */
	{ AS(modfnext_args), (sy_call_t *)modfnext, AUE_NULL, NULL, 0, 0 },	/* 302 = modfnext */
	{ AS(modfind_args), (sy_call_t *)modfind, AUE_NULL, NULL, 0, 0 },	/* 303 = modfind */
	{ AS(kldload_args), (sy_call_t *)kldload, AUE_MODLOAD, NULL, 0, 0 },	/* 304 = kldload */
	{ AS(kldunload_args), (sy_call_t *)kldunload, AUE_MODUNLOAD, NULL, 0, 0 },	/* 305 = kldunload */
	{ AS(kldfind_args), (sy_call_t *)kldfind, AUE_NULL, NULL, 0, 0 },	/* 306 = kldfind */
	{ AS(kldnext_args), (sy_call_t *)kldnext, AUE_NULL, NULL, 0, 0 },	/* 307 = kldnext */
	{ AS(kldstat_args), (sy_call_t *)kldstat, AUE_NULL, NULL, 0, 0 },	/* 308 = kldstat */
	{ AS(kldfirstmod_args), (sy_call_t *)kldfirstmod, AUE_NULL, NULL, 0, 0 },	/* 309 = kldfirstmod */
	{ AS(getsid_args), (sy_call_t *)getsid, AUE_GETSID, NULL, 0, 0 },	/* 310 = getsid */
	{ AS(setresuid_args), (sy_call_t *)setresuid, AUE_SETRESUID, NULL, 0, 0 },	/* 311 = setresuid */
	{ AS(setresgid_args), (sy_call_t *)setresgid, AUE_SETRESGID, NULL, 0, 0 },	/* 312 = setresgid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 313 = obsolete signanosleep */
	{ AS(freebsd32_aio_return_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 314 = freebsd32_aio_return */
	{ AS(freebsd32_aio_suspend_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 315 = freebsd32_aio_suspend */
	{ AS(freebsd32_aio_cancel_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 316 = freebsd32_aio_cancel */
	{ AS(freebsd32_aio_error_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 317 = freebsd32_aio_error */
	{ AS(freebsd32_oaio_read_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 318 = freebsd32_oaio_read */
	{ AS(freebsd32_oaio_write_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 319 = freebsd32_oaio_write */
	{ AS(freebsd32_olio_listio_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 320 = freebsd32_olio_listio */
	{ 0, (sy_call_t *)yield, AUE_NULL, NULL, 0, 0 },		/* 321 = yield */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 322 = obsolete thr_sleep */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 323 = obsolete thr_wakeup */
	{ AS(mlockall_args), (sy_call_t *)mlockall, AUE_MLOCKALL, NULL, 0, 0 },	/* 324 = mlockall */
	{ 0, (sy_call_t *)munlockall, AUE_MUNLOCKALL, NULL, 0, 0 },	/* 325 = munlockall */
	{ AS(__getcwd_args), (sy_call_t *)__getcwd, AUE_GETCWD, NULL, 0, 0 },	/* 326 = __getcwd */
	{ AS(sched_setparam_args), (sy_call_t *)sched_setparam, AUE_NULL, NULL, 0, 0 },	/* 327 = sched_setparam */
	{ AS(sched_getparam_args), (sy_call_t *)sched_getparam, AUE_NULL, NULL, 0, 0 },	/* 328 = sched_getparam */
	{ AS(sched_setscheduler_args), (sy_call_t *)sched_setscheduler, AUE_NULL, NULL, 0, 0 },	/* 329 = sched_setscheduler */
	{ AS(sched_getscheduler_args), (sy_call_t *)sched_getscheduler, AUE_NULL, NULL, 0, 0 },	/* 330 = sched_getscheduler */
	{ 0, (sy_call_t *)sched_yield, AUE_NULL, NULL, 0, 0 },	/* 331 = sched_yield */
	{ AS(sched_get_priority_max_args), (sy_call_t *)sched_get_priority_max, AUE_NULL, NULL, 0, 0 },	/* 332 = sched_get_priority_max */
	{ AS(sched_get_priority_min_args), (sy_call_t *)sched_get_priority_min, AUE_NULL, NULL, 0, 0 },	/* 333 = sched_get_priority_min */
	{ AS(sched_rr_get_interval_args), (sy_call_t *)sched_rr_get_interval, AUE_NULL, NULL, 0, 0 },	/* 334 = sched_rr_get_interval */
	{ AS(utrace_args), (sy_call_t *)utrace, AUE_NULL, NULL, 0, 0 },	/* 335 = utrace */
	{ compat4(AS(freebsd4_freebsd32_sendfile_args),freebsd32_sendfile), AUE_SENDFILE, NULL, 0, 0 },	/* 336 = freebsd4 freebsd32_sendfile */
	{ AS(kldsym_args), (sy_call_t *)kldsym, AUE_NULL, NULL, 0, 0 },	/* 337 = kldsym */
	{ AS(freebsd32_jail_args), (sy_call_t *)freebsd32_jail, AUE_JAIL, NULL, 0, 0 },	/* 338 = freebsd32_jail */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 339 = pioctl */
	{ AS(sigprocmask_args), (sy_call_t *)sigprocmask, AUE_SIGPROCMASK, NULL, 0, 0 },	/* 340 = sigprocmask */
	{ AS(sigsuspend_args), (sy_call_t *)sigsuspend, AUE_SIGSUSPEND, NULL, 0, 0 },	/* 341 = sigsuspend */
	{ compat4(AS(freebsd4_freebsd32_sigaction_args),freebsd32_sigaction), AUE_SIGACTION, NULL, 0, 0 },	/* 342 = freebsd4 freebsd32_sigaction */
	{ AS(sigpending_args), (sy_call_t *)sigpending, AUE_SIGPENDING, NULL, 0, 0 },	/* 343 = sigpending */
	{ compat4(AS(freebsd4_freebsd32_sigreturn_args),freebsd32_sigreturn), AUE_SIGRETURN, NULL, 0, 0 },	/* 344 = freebsd4 freebsd32_sigreturn */
	{ AS(freebsd32_sigtimedwait_args), (sy_call_t *)freebsd32_sigtimedwait, AUE_SIGWAIT, NULL, 0, 0 },	/* 345 = freebsd32_sigtimedwait */
	{ AS(freebsd32_sigwaitinfo_args), (sy_call_t *)freebsd32_sigwaitinfo, AUE_NULL, NULL, 0, 0 },	/* 346 = freebsd32_sigwaitinfo */
	{ AS(__acl_get_file_args), (sy_call_t *)__acl_get_file, AUE_NULL, NULL, 0, 0 },	/* 347 = __acl_get_file */
	{ AS(__acl_set_file_args), (sy_call_t *)__acl_set_file, AUE_NULL, NULL, 0, 0 },	/* 348 = __acl_set_file */
	{ AS(__acl_get_fd_args), (sy_call_t *)__acl_get_fd, AUE_NULL, NULL, 0, 0 },	/* 349 = __acl_get_fd */
	{ AS(__acl_set_fd_args), (sy_call_t *)__acl_set_fd, AUE_NULL, NULL, 0, 0 },	/* 350 = __acl_set_fd */
	{ AS(__acl_delete_file_args), (sy_call_t *)__acl_delete_file, AUE_NULL, NULL, 0, 0 },	/* 351 = __acl_delete_file */
	{ AS(__acl_delete_fd_args), (sy_call_t *)__acl_delete_fd, AUE_NULL, NULL, 0, 0 },	/* 352 = __acl_delete_fd */
	{ AS(__acl_aclcheck_file_args), (sy_call_t *)__acl_aclcheck_file, AUE_NULL, NULL, 0, 0 },	/* 353 = __acl_aclcheck_file */
	{ AS(__acl_aclcheck_fd_args), (sy_call_t *)__acl_aclcheck_fd, AUE_NULL, NULL, 0, 0 },	/* 354 = __acl_aclcheck_fd */
	{ AS(extattrctl_args), (sy_call_t *)extattrctl, AUE_EXTATTRCTL, NULL, 0, 0 },	/* 355 = extattrctl */
	{ AS(extattr_set_file_args), (sy_call_t *)extattr_set_file, AUE_EXTATTR_SET_FILE, NULL, 0, 0 },	/* 356 = extattr_set_file */
	{ AS(extattr_get_file_args), (sy_call_t *)extattr_get_file, AUE_EXTATTR_GET_FILE, NULL, 0, 0 },	/* 357 = extattr_get_file */
	{ AS(extattr_delete_file_args), (sy_call_t *)extattr_delete_file, AUE_EXTATTR_DELETE_FILE, NULL, 0, 0 },	/* 358 = extattr_delete_file */
	{ AS(freebsd32_aio_waitcomplete_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 359 = freebsd32_aio_waitcomplete */
	{ AS(getresuid_args), (sy_call_t *)getresuid, AUE_GETRESUID, NULL, 0, 0 },	/* 360 = getresuid */
	{ AS(getresgid_args), (sy_call_t *)getresgid, AUE_GETRESGID, NULL, 0, 0 },	/* 361 = getresgid */
	{ 0, (sy_call_t *)kqueue, AUE_KQUEUE, NULL, 0, 0 },		/* 362 = kqueue */
	{ AS(freebsd32_kevent_args), (sy_call_t *)freebsd32_kevent, AUE_NULL, NULL, 0, 0 },	/* 363 = freebsd32_kevent */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 364 = __cap_get_proc */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 365 = __cap_set_proc */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 366 = __cap_get_fd */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 367 = __cap_get_file */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 368 = __cap_set_fd */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 369 = __cap_set_file */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 370 = nosys */
	{ AS(extattr_set_fd_args), (sy_call_t *)extattr_set_fd, AUE_EXTATTR_SET_FD, NULL, 0, 0 },	/* 371 = extattr_set_fd */
	{ AS(extattr_get_fd_args), (sy_call_t *)extattr_get_fd, AUE_EXTATTR_GET_FD, NULL, 0, 0 },	/* 372 = extattr_get_fd */
	{ AS(extattr_delete_fd_args), (sy_call_t *)extattr_delete_fd, AUE_EXTATTR_DELETE_FD, NULL, 0, 0 },	/* 373 = extattr_delete_fd */
	{ AS(__setugid_args), (sy_call_t *)__setugid, AUE_NULL, NULL, 0, 0 },	/* 374 = __setugid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 375 = nfsclnt */
	{ AS(eaccess_args), (sy_call_t *)eaccess, AUE_EACCESS, NULL, 0, 0 },	/* 376 = eaccess */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 377 = afs_syscall */
	{ AS(freebsd32_nmount_args), (sy_call_t *)freebsd32_nmount, AUE_NMOUNT, NULL, 0, 0 },	/* 378 = freebsd32_nmount */
	{ 0, (sy_call_t *)kse_exit, AUE_NULL, NULL, 0, 0 },		/* 379 = kse_exit */
	{ AS(kse_wakeup_args), (sy_call_t *)kse_wakeup, AUE_NULL, NULL, 0, 0 },	/* 380 = kse_wakeup */
	{ AS(kse_create_args), (sy_call_t *)kse_create, AUE_NULL, NULL, 0, 0 },	/* 381 = kse_create */
	{ AS(kse_thr_interrupt_args), (sy_call_t *)kse_thr_interrupt, AUE_NULL, NULL, 0, 0 },	/* 382 = kse_thr_interrupt */
	{ 0, (sy_call_t *)kse_release, AUE_NULL, NULL, 0, 0 },	/* 383 = kse_release */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 384 = __mac_get_proc */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 385 = __mac_set_proc */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 386 = __mac_get_fd */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 387 = __mac_get_file */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 388 = __mac_set_fd */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 389 = __mac_set_file */
	{ AS(kenv_args), (sy_call_t *)kenv, AUE_NULL, NULL, 0, 0 },	/* 390 = kenv */
	{ AS(lchflags_args), (sy_call_t *)lchflags, AUE_LCHFLAGS, NULL, 0, 0 },	/* 391 = lchflags */
	{ AS(uuidgen_args), (sy_call_t *)uuidgen, AUE_NULL, NULL, 0, 0 },	/* 392 = uuidgen */
	{ AS(freebsd32_sendfile_args), (sy_call_t *)freebsd32_sendfile, AUE_SENDFILE, NULL, 0, 0 },	/* 393 = freebsd32_sendfile */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 394 = mac_syscall */
	{ AS(getfsstat_args), (sy_call_t *)getfsstat, AUE_GETFSSTAT, NULL, 0, 0 },	/* 395 = getfsstat */
	{ AS(statfs_args), (sy_call_t *)statfs, AUE_STATFS, NULL, 0, 0 },	/* 396 = statfs */
	{ AS(fstatfs_args), (sy_call_t *)fstatfs, AUE_FSTATFS, NULL, 0, 0 },	/* 397 = fstatfs */
	{ AS(fhstatfs_args), (sy_call_t *)fhstatfs, AUE_FHSTATFS, NULL, 0, 0 },	/* 398 = fhstatfs */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 399 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 400 = ksem_close */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 401 = ksem_post */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 402 = ksem_wait */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 403 = ksem_trywait */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 404 = ksem_init */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 405 = ksem_open */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 406 = ksem_unlink */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 407 = ksem_getvalue */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 408 = ksem_destroy */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 409 = __mac_get_pid */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 410 = __mac_get_link */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 411 = __mac_set_link */
	{ AS(extattr_set_link_args), (sy_call_t *)extattr_set_link, AUE_EXTATTR_SET_LINK, NULL, 0, 0 },	/* 412 = extattr_set_link */
	{ AS(extattr_get_link_args), (sy_call_t *)extattr_get_link, AUE_EXTATTR_GET_LINK, NULL, 0, 0 },	/* 413 = extattr_get_link */
	{ AS(extattr_delete_link_args), (sy_call_t *)extattr_delete_link, AUE_EXTATTR_DELETE_LINK, NULL, 0, 0 },	/* 414 = extattr_delete_link */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 415 = __mac_execve */
	{ AS(freebsd32_sigaction_args), (sy_call_t *)freebsd32_sigaction, AUE_SIGACTION, NULL, 0, 0 },	/* 416 = freebsd32_sigaction */
	{ AS(freebsd32_sigreturn_args), (sy_call_t *)freebsd32_sigreturn, AUE_SIGRETURN, NULL, 0, 0 },	/* 417 = freebsd32_sigreturn */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 418 = __xstat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 419 = __xfstat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 420 = __xlstat */
	{ AS(freebsd32_getcontext_args), (sy_call_t *)freebsd32_getcontext, AUE_NULL, NULL, 0, 0 },	/* 421 = freebsd32_getcontext */
	{ AS(freebsd32_setcontext_args), (sy_call_t *)freebsd32_setcontext, AUE_NULL, NULL, 0, 0 },	/* 422 = freebsd32_setcontext */
	{ AS(freebsd32_swapcontext_args), (sy_call_t *)freebsd32_swapcontext, AUE_NULL, NULL, 0, 0 },	/* 423 = freebsd32_swapcontext */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 424 = swapoff */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 425 = __acl_get_link */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 426 = __acl_set_link */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 427 = __acl_delete_link */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 428 = __acl_aclcheck_link */
	{ AS(sigwait_args), (sy_call_t *)sigwait, AUE_SIGWAIT, NULL, 0, 0 },	/* 429 = sigwait */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 430 = thr_create; */
	{ AS(thr_exit_args), (sy_call_t *)thr_exit, AUE_NULL, NULL, 0, 0 },	/* 431 = thr_exit */
	{ AS(thr_self_args), (sy_call_t *)thr_self, AUE_NULL, NULL, 0, 0 },	/* 432 = thr_self */
	{ AS(thr_kill_args), (sy_call_t *)thr_kill, AUE_NULL, NULL, 0, 0 },	/* 433 = thr_kill */
	{ AS(freebsd32_umtx_lock_args), (sy_call_t *)freebsd32_umtx_lock, AUE_NULL, NULL, 0, 0 },	/* 434 = freebsd32_umtx_lock */
	{ AS(freebsd32_umtx_unlock_args), (sy_call_t *)freebsd32_umtx_unlock, AUE_NULL, NULL, 0, 0 },	/* 435 = freebsd32_umtx_unlock */
	{ AS(jail_attach_args), (sy_call_t *)jail_attach, AUE_NULL, NULL, 0, 0 },	/* 436 = jail_attach */
	{ AS(extattr_list_fd_args), (sy_call_t *)extattr_list_fd, AUE_EXTATTR_LIST_FD, NULL, 0, 0 },	/* 437 = extattr_list_fd */
	{ AS(extattr_list_file_args), (sy_call_t *)extattr_list_file, AUE_EXTATTR_LIST_FILE, NULL, 0, 0 },	/* 438 = extattr_list_file */
	{ AS(extattr_list_link_args), (sy_call_t *)extattr_list_link, AUE_EXTATTR_LIST_LINK, NULL, 0, 0 },	/* 439 = extattr_list_link */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 440 = kse_switchin */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 441 = ksem_timedwait */
	{ AS(freebsd32_thr_suspend_args), (sy_call_t *)freebsd32_thr_suspend, AUE_NULL, NULL, 0, 0 },	/* 442 = freebsd32_thr_suspend */
	{ AS(thr_wake_args), (sy_call_t *)thr_wake, AUE_NULL, NULL, 0, 0 },	/* 443 = thr_wake */
	{ AS(kldunloadf_args), (sy_call_t *)kldunloadf, AUE_MODUNLOAD, NULL, 0, 0 },	/* 444 = kldunloadf */
	{ AS(audit_args), (sy_call_t *)audit, AUE_AUDIT, NULL, 0, 0 },	/* 445 = audit */
	{ AS(auditon_args), (sy_call_t *)auditon, AUE_AUDITON, NULL, 0, 0 },	/* 446 = auditon */
	{ AS(getauid_args), (sy_call_t *)getauid, AUE_GETAUID, NULL, 0, 0 },	/* 447 = getauid */
	{ AS(setauid_args), (sy_call_t *)setauid, AUE_SETAUID, NULL, 0, 0 },	/* 448 = setauid */
	{ AS(getaudit_args), (sy_call_t *)getaudit, AUE_GETAUDIT, NULL, 0, 0 },	/* 449 = getaudit */
	{ AS(setaudit_args), (sy_call_t *)setaudit, AUE_SETAUDIT, NULL, 0, 0 },	/* 450 = setaudit */
	{ AS(getaudit_addr_args), (sy_call_t *)getaudit_addr, AUE_GETAUDIT_ADDR, NULL, 0, 0 },	/* 451 = getaudit_addr */
	{ AS(setaudit_addr_args), (sy_call_t *)setaudit_addr, AUE_SETAUDIT_ADDR, NULL, 0, 0 },	/* 452 = setaudit_addr */
	{ AS(auditctl_args), (sy_call_t *)auditctl, AUE_AUDITCTL, NULL, 0, 0 },	/* 453 = auditctl */
	{ AS(freebsd32_umtx_op_args), (sy_call_t *)freebsd32_umtx_op, AUE_NULL, NULL, 0, 0 },	/* 454 = freebsd32_umtx_op */
	{ AS(freebsd32_thr_new_args), (sy_call_t *)freebsd32_thr_new, AUE_NULL, NULL, 0, 0 },	/* 455 = freebsd32_thr_new */
	{ AS(sigqueue_args), (sy_call_t *)sigqueue, AUE_NULL, NULL, 0, 0 },	/* 456 = sigqueue */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 457 = kmq_open */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 458 = kmq_setattr */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 459 = kmq_timedreceive */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 460 = kmq_timedsend */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 461 = kmq_notify */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 462 = kmq_unlink */
	{ AS(abort2_args), (sy_call_t *)abort2, AUE_NULL, NULL, 0, 0 },	/* 463 = abort2 */
	{ AS(thr_set_name_args), (sy_call_t *)thr_set_name, AUE_NULL, NULL, 0, 0 },	/* 464 = thr_set_name */
	{ AS(freebsd32_aio_fsync_args), (sy_call_t *)lkmressys, AUE_NULL, NULL, 0, 0 },	/* 465 = freebsd32_aio_fsync */
	{ AS(rtprio_thread_args), (sy_call_t *)rtprio_thread, AUE_RTPRIO, NULL, 0, 0 },	/* 466 = rtprio_thread */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 467 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 468 = nosys */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 469 = __getpath_fromfd */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 470 = __getpath_fromaddr */
	{ AS(sctp_peeloff_args), (sy_call_t *)sctp_peeloff, AUE_NULL, NULL, 0, 0 },	/* 471 = sctp_peeloff */
	{ AS(sctp_generic_sendmsg_args), (sy_call_t *)sctp_generic_sendmsg, AUE_NULL, NULL, 0, 0 },	/* 472 = sctp_generic_sendmsg */
	{ AS(sctp_generic_sendmsg_iov_args), (sy_call_t *)sctp_generic_sendmsg_iov, AUE_NULL, NULL, 0, 0 },	/* 473 = sctp_generic_sendmsg_iov */
	{ AS(sctp_generic_recvmsg_args), (sy_call_t *)sctp_generic_recvmsg, AUE_NULL, NULL, 0, 0 },	/* 474 = sctp_generic_recvmsg */
	{ AS(freebsd32_pread_args), (sy_call_t *)freebsd32_pread, AUE_PREAD, NULL, 0, 0 },	/* 475 = freebsd32_pread */
	{ AS(freebsd32_pwrite_args), (sy_call_t *)freebsd32_pwrite, AUE_PWRITE, NULL, 0, 0 },	/* 476 = freebsd32_pwrite */
	{ AS(freebsd32_mmap_args), (sy_call_t *)freebsd32_mmap, AUE_MMAP, NULL, 0, 0 },	/* 477 = freebsd32_mmap */
	{ AS(freebsd32_lseek_args), (sy_call_t *)freebsd32_lseek, AUE_LSEEK, NULL, 0, 0 },	/* 478 = freebsd32_lseek */
	{ AS(freebsd32_truncate_args), (sy_call_t *)freebsd32_truncate, AUE_TRUNCATE, NULL, 0, 0 },	/* 479 = freebsd32_truncate */
	{ AS(freebsd32_ftruncate_args), (sy_call_t *)freebsd32_ftruncate, AUE_FTRUNCATE, NULL, 0, 0 },	/* 480 = freebsd32_ftruncate */
	{ AS(thr_kill2_args), (sy_call_t *)thr_kill2, AUE_KILL, NULL, 0, 0 },	/* 481 = thr_kill2 */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 482 = shm_open */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 483 = shm_unlink */
	{ AS(cpuset_args), (sy_call_t *)cpuset, AUE_NULL, NULL, 0, 0 },	/* 484 = cpuset */
	{ AS(freebsd32_cpuset_setid_args), (sy_call_t *)freebsd32_cpuset_setid, AUE_NULL, NULL, 0, 0 },	/* 485 = freebsd32_cpuset_setid */
	{ AS(freebsd32_cpuset_getid_args), (sy_call_t *)freebsd32_cpuset_getid, AUE_NULL, NULL, 0, 0 },	/* 486 = freebsd32_cpuset_getid */
	{ AS(freebsd32_cpuset_getaffinity_args), (sy_call_t *)freebsd32_cpuset_getaffinity, AUE_NULL, NULL, 0, 0 },	/* 487 = freebsd32_cpuset_getaffinity */
	{ AS(freebsd32_cpuset_setaffinity_args), (sy_call_t *)freebsd32_cpuset_setaffinity, AUE_NULL, NULL, 0, 0 },	/* 488 = freebsd32_cpuset_setaffinity */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 489 = faccessat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 490 = fchmodat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 491 = fchownat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 492 = freebsd32_fexecve */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 493 = freebsd32_fstatat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 494 = freebsd32_futimesat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 495 = linkat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 496 = mkdirat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 497 = mkfifoat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 498 = mknodat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 499 = openat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 500 = readlinkat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 501 = renameat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 502 = symlinkat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 503 = unlinkat */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 504 = posix_openpt */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 505 = gssd_syscall */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 506 = freebsd32_jail_get */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 507 = freebsd32_jail_set */
	{ 0, (sy_call_t *)nosys, AUE_NULL, NULL, 0, 0 },			/* 508 = jail_remove */
	{ AS(closefrom_args), (sy_call_t *)closefrom, AUE_CLOSEFROM, NULL, 0, 0 },	/* 509 = closefrom */
	{ AS(freebsd32_semctl_args), (sy_call_t *)freebsd32_semctl, AUE_SEMCTL, NULL, 0, 0 },	/* 510 = freebsd32_semctl */
	{ AS(freebsd32_msgctl_args), (sy_call_t *)freebsd32_msgctl, AUE_MSGCTL, NULL, 0, 0 },	/* 511 = freebsd32_msgctl */
	{ AS(freebsd32_shmctl_args), (sy_call_t *)freebsd32_shmctl, AUE_SHMCTL, NULL, 0, 0 },	/* 512 = freebsd32_shmctl */
};
